<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for manufacturers StructType
 * @subpackage Structs
 */
class Manufacturers extends AbstractStructBase
{
    /**
     * The manufacturer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ManufacturerImpl[]
     */
    public $manufacturer;
    /**
     * Constructor method for manufacturers
     * @uses Manufacturers::setManufacturer()
     * @param \StructType\ManufacturerImpl[] $manufacturer
     */
    public function __construct(array $manufacturer = array())
    {
        $this
            ->setManufacturer($manufacturer);
    }
    /**
     * Get manufacturer value
     * @return \StructType\ManufacturerImpl[]|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @throws \InvalidArgumentException
     * @param \StructType\ManufacturerImpl[] $manufacturer
     * @return \StructType\Manufacturers
     */
    public function setManufacturer(array $manufacturer = array())
    {
        foreach ($manufacturer as $manufacturersManufacturerItem) {
            // validation for constraint: itemType
            if (!$manufacturersManufacturerItem instanceof \StructType\ManufacturerImpl) {
                throw new \InvalidArgumentException(sprintf('The manufacturer property can only contain items of \StructType\ManufacturerImpl, "%s" given', is_object($manufacturersManufacturerItem) ? get_class($manufacturersManufacturerItem) : gettype($manufacturersManufacturerItem)), __LINE__);
            }
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Add item to manufacturer value
     * @throws \InvalidArgumentException
     * @param \StructType\ManufacturerImpl $item
     * @return \StructType\Manufacturers
     */
    public function addToManufacturer(\StructType\ManufacturerImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ManufacturerImpl) {
            throw new \InvalidArgumentException(sprintf('The manufacturer property can only contain items of \StructType\ManufacturerImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->manufacturer[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Manufacturers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
