<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for m2MImeiSearchResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:m2MImeiSearchResponseImpl
 * @subpackage Structs
 */
class M2MImeiSearchResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The imeiDetails
     * @var \StructType\ImeiDetails
     */
    public $imeiDetails;
    /**
     * Constructor method for m2MImeiSearchResponseImpl
     * @uses M2MImeiSearchResponseImpl::setTotalNumberOfRecords()
     * @uses M2MImeiSearchResponseImpl::setImeiDetails()
     * @param int $totalNumberOfRecords
     * @param \StructType\ImeiDetails $imeiDetails
     */
    public function __construct($totalNumberOfRecords = null, \StructType\ImeiDetails $imeiDetails = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setImeiDetails($imeiDetails);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\M2MImeiSearchResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get imeiDetails value
     * @return \StructType\ImeiDetails|null
     */
    public function getImeiDetails()
    {
        return $this->imeiDetails;
    }
    /**
     * Set imeiDetails value
     * @param \StructType\ImeiDetails $imeiDetails
     * @return \StructType\M2MImeiSearchResponseImpl
     */
    public function setImeiDetails(\StructType\ImeiDetails $imeiDetails = null)
    {
        $this->imeiDetails = $imeiDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\M2MImeiSearchResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
