<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loadIMEIRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:loadIMEIRequestImpl
 * @subpackage Structs
 */
class LoadIMEIRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The modelId
     * @var string
     */
    public $modelId;
    /**
     * The devices
     * @var \StructType\Devices
     */
    public $devices;
    /**
     * The manufacturerId
     * @var string
     */
    public $manufacturerId;
    /**
     * The network
     * @var string
     */
    public $network;
    /**
     * Constructor method for loadIMEIRequestImpl
     * @uses LoadIMEIRequestImpl::setServiceType()
     * @uses LoadIMEIRequestImpl::setModelId()
     * @uses LoadIMEIRequestImpl::setDevices()
     * @uses LoadIMEIRequestImpl::setManufacturerId()
     * @uses LoadIMEIRequestImpl::setNetwork()
     * @param string $serviceType
     * @param string $modelId
     * @param \StructType\Devices $devices
     * @param string $manufacturerId
     * @param string $network
     */
    public function __construct($serviceType = null, $modelId = null, \StructType\Devices $devices = null, $manufacturerId = null, $network = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setModelId($modelId)
            ->setDevices($devices)
            ->setManufacturerId($manufacturerId)
            ->setNetwork($network);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\LoadIMEIRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get modelId value
     * @return string|null
     */
    public function getModelId()
    {
        return $this->modelId;
    }
    /**
     * Set modelId value
     * @param string $modelId
     * @return \StructType\LoadIMEIRequestImpl
     */
    public function setModelId($modelId = null)
    {
        // validation for constraint: string
        if (!is_null($modelId) && !is_string($modelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelId)), __LINE__);
        }
        $this->modelId = $modelId;
        return $this;
    }
    /**
     * Get devices value
     * @return \StructType\Devices|null
     */
    public function getDevices()
    {
        return $this->devices;
    }
    /**
     * Set devices value
     * @param \StructType\Devices $devices
     * @return \StructType\LoadIMEIRequestImpl
     */
    public function setDevices(\StructType\Devices $devices = null)
    {
        $this->devices = $devices;
        return $this;
    }
    /**
     * Get manufacturerId value
     * @return string|null
     */
    public function getManufacturerId()
    {
        return $this->manufacturerId;
    }
    /**
     * Set manufacturerId value
     * @param string $manufacturerId
     * @return \StructType\LoadIMEIRequestImpl
     */
    public function setManufacturerId($manufacturerId = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerId) && !is_string($manufacturerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturerId)), __LINE__);
        }
        $this->manufacturerId = $manufacturerId;
        return $this;
    }
    /**
     * Get network value
     * @return string|null
     */
    public function getNetwork()
    {
        return $this->network;
    }
    /**
     * Set network value
     * @uses \EnumType\NetworkEnum::valueIsValid()
     * @uses \EnumType\NetworkEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $network
     * @return \StructType\LoadIMEIRequestImpl
     */
    public function setNetwork($network = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NetworkEnum::valueIsValid($network)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $network, implode(', ', \EnumType\NetworkEnum::getValidValues())), __LINE__);
        }
        $this->network = $network;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoadIMEIRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
