<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for lineItems StructType
 * @subpackage Structs
 */
class LineItems extends AbstractStructBase
{
    /**
     * The lineItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VoucherLineItemImpl[]
     */
    public $lineItem;
    /**
     * Constructor method for lineItems
     * @uses LineItems::setLineItem()
     * @param \StructType\VoucherLineItemImpl[] $lineItem
     */
    public function __construct(array $lineItem = array())
    {
        $this
            ->setLineItem($lineItem);
    }
    /**
     * Get lineItem value
     * @return \StructType\VoucherLineItemImpl[]|null
     */
    public function getLineItem()
    {
        return $this->lineItem;
    }
    /**
     * Set lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherLineItemImpl[] $lineItem
     * @return \StructType\LineItems
     */
    public function setLineItem(array $lineItem = array())
    {
        foreach ($lineItem as $lineItemsLineItemItem) {
            // validation for constraint: itemType
            if (!$lineItemsLineItemItem instanceof \StructType\VoucherLineItemImpl) {
                throw new \InvalidArgumentException(sprintf('The lineItem property can only contain items of \StructType\VoucherLineItemImpl, "%s" given', is_object($lineItemsLineItemItem) ? get_class($lineItemsLineItemItem) : gettype($lineItemsLineItemItem)), __LINE__);
            }
        }
        $this->lineItem = $lineItem;
        return $this;
    }
    /**
     * Add item to lineItem value
     * @throws \InvalidArgumentException
     * @param \StructType\VoucherLineItemImpl $item
     * @return \StructType\LineItems
     */
    public function addToLineItem(\StructType\VoucherLineItemImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VoucherLineItemImpl) {
            throw new \InvalidArgumentException(sprintf('The lineItem property can only contain items of \StructType\VoucherLineItemImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lineItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
