<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for languageChoiceImpl StructType
 * @subpackage Structs
 */
class LanguageChoiceImpl extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The serviceLanguageType
     * @var string
     */
    public $serviceLanguageType;
    /**
     * The languageName
     * @var string
     */
    public $languageName;
    /**
     * Constructor method for languageChoiceImpl
     * @uses LanguageChoiceImpl::setId()
     * @uses LanguageChoiceImpl::setServiceLanguageType()
     * @uses LanguageChoiceImpl::setLanguageName()
     * @param string $id
     * @param string $serviceLanguageType
     * @param string $languageName
     */
    public function __construct($id = null, $serviceLanguageType = null, $languageName = null)
    {
        $this
            ->setId($id)
            ->setServiceLanguageType($serviceLanguageType)
            ->setLanguageName($languageName);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\LanguageChoiceImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get serviceLanguageType value
     * @return string|null
     */
    public function getServiceLanguageType()
    {
        return $this->serviceLanguageType;
    }
    /**
     * Set serviceLanguageType value
     * @uses \EnumType\ServiceLanguageTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceLanguageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceLanguageType
     * @return \StructType\LanguageChoiceImpl
     */
    public function setServiceLanguageType($serviceLanguageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceLanguageTypeEnum::valueIsValid($serviceLanguageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceLanguageType, implode(', ', \EnumType\ServiceLanguageTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceLanguageType = $serviceLanguageType;
        return $this;
    }
    /**
     * Get languageName value
     * @return string|null
     */
    public function getLanguageName()
    {
        return $this->languageName;
    }
    /**
     * Set languageName value
     * @param string $languageName
     * @return \StructType\LanguageChoiceImpl
     */
    public function setLanguageName($languageName = null)
    {
        // validation for constraint: string
        if (!is_null($languageName) && !is_string($languageName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageName)), __LINE__);
        }
        $this->languageName = $languageName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LanguageChoiceImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
