<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getScratchCardsRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getScratchCardsRequestImpl
 * @subpackage Structs
 */
class GetScratchCardsRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The searchType1
     * @var string
     */
    public $searchType1;
    /**
     * The searchOperator1
     * @var string
     */
    public $searchOperator1;
    /**
     * The searchValue1
     * @var string
     */
    public $searchValue1;
    /**
     * The searchType2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchType2;
    /**
     * The searchOperator2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchOperator2;
    /**
     * The searchValue2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $searchValue2;
    /**
     * The realtime
     * @var bool
     */
    public $realtime;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for getScratchCardsRequestImpl
     * @uses GetScratchCardsRequestImpl::setSearchType1()
     * @uses GetScratchCardsRequestImpl::setSearchOperator1()
     * @uses GetScratchCardsRequestImpl::setSearchValue1()
     * @uses GetScratchCardsRequestImpl::setSearchType2()
     * @uses GetScratchCardsRequestImpl::setSearchOperator2()
     * @uses GetScratchCardsRequestImpl::setSearchValue2()
     * @uses GetScratchCardsRequestImpl::setRealtime()
     * @uses GetScratchCardsRequestImpl::setLimit()
     * @uses GetScratchCardsRequestImpl::setStartRow()
     * @param string $searchType1
     * @param string $searchOperator1
     * @param string $searchValue1
     * @param string $searchType2
     * @param string $searchOperator2
     * @param string $searchValue2
     * @param bool $realtime
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($searchType1 = null, $searchOperator1 = null, $searchValue1 = null, $searchType2 = null, $searchOperator2 = null, $searchValue2 = null, $realtime = null, $limit = null, $startRow = null)
    {
        $this
            ->setSearchType1($searchType1)
            ->setSearchOperator1($searchOperator1)
            ->setSearchValue1($searchValue1)
            ->setSearchType2($searchType2)
            ->setSearchOperator2($searchOperator2)
            ->setSearchValue2($searchValue2)
            ->setRealtime($realtime)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get searchType1 value
     * @return string|null
     */
    public function getSearchType1()
    {
        return $this->searchType1;
    }
    /**
     * Set searchType1 value
     * @uses \EnumType\TelephonyScratchCardSearchTypeEnum::valueIsValid()
     * @uses \EnumType\TelephonyScratchCardSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType1
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setSearchType1($searchType1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TelephonyScratchCardSearchTypeEnum::valueIsValid($searchType1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType1, implode(', ', \EnumType\TelephonyScratchCardSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType1 = $searchType1;
        return $this;
    }
    /**
     * Get searchOperator1 value
     * @return string|null
     */
    public function getSearchOperator1()
    {
        return $this->searchOperator1;
    }
    /**
     * Set searchOperator1 value
     * @uses \EnumType\SearchOperatorEnum::valueIsValid()
     * @uses \EnumType\SearchOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchOperator1
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setSearchOperator1($searchOperator1 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchOperatorEnum::valueIsValid($searchOperator1)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchOperator1, implode(', ', \EnumType\SearchOperatorEnum::getValidValues())), __LINE__);
        }
        $this->searchOperator1 = $searchOperator1;
        return $this;
    }
    /**
     * Get searchValue1 value
     * @return string|null
     */
    public function getSearchValue1()
    {
        return $this->searchValue1;
    }
    /**
     * Set searchValue1 value
     * @param string $searchValue1
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setSearchValue1($searchValue1 = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue1) && !is_string($searchValue1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchValue1)), __LINE__);
        }
        $this->searchValue1 = $searchValue1;
        return $this;
    }
    /**
     * Get searchType2 value
     * @return string|null
     */
    public function getSearchType2()
    {
        return $this->searchType2;
    }
    /**
     * Set searchType2 value
     * @uses \EnumType\TelephonyScratchCardSearchTypeEnum::valueIsValid()
     * @uses \EnumType\TelephonyScratchCardSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType2
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setSearchType2($searchType2 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TelephonyScratchCardSearchTypeEnum::valueIsValid($searchType2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType2, implode(', ', \EnumType\TelephonyScratchCardSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType2 = $searchType2;
        return $this;
    }
    /**
     * Get searchOperator2 value
     * @return string|null
     */
    public function getSearchOperator2()
    {
        return $this->searchOperator2;
    }
    /**
     * Set searchOperator2 value
     * @uses \EnumType\SearchOperatorEnum::valueIsValid()
     * @uses \EnumType\SearchOperatorEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchOperator2
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setSearchOperator2($searchOperator2 = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchOperatorEnum::valueIsValid($searchOperator2)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchOperator2, implode(', ', \EnumType\SearchOperatorEnum::getValidValues())), __LINE__);
        }
        $this->searchOperator2 = $searchOperator2;
        return $this;
    }
    /**
     * Get searchValue2 value
     * @return string|null
     */
    public function getSearchValue2()
    {
        return $this->searchValue2;
    }
    /**
     * Set searchValue2 value
     * @param string $searchValue2
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setSearchValue2($searchValue2 = null)
    {
        // validation for constraint: string
        if (!is_null($searchValue2) && !is_string($searchValue2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchValue2)), __LINE__);
        }
        $this->searchValue2 = $searchValue2;
        return $this;
    }
    /**
     * Get realtime value
     * @return bool|null
     */
    public function getRealtime()
    {
        return $this->realtime;
    }
    /**
     * Set realtime value
     * @param bool $realtime
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setRealtime($realtime = null)
    {
        $this->realtime = $realtime;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetScratchCardsRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
