<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getResourceInventoryReportRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getResourceInventoryReportRequestImpl
 * @subpackage Structs
 */
class GetResourceInventoryReportRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * The submarket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarket;
    /**
     * The gwGlobal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gwGlobal;
    /**
     * Constructor method for getResourceInventoryReportRequestImpl
     * @uses GetResourceInventoryReportRequestImpl::setServiceType()
     * @uses GetResourceInventoryReportRequestImpl::setType()
     * @uses GetResourceInventoryReportRequestImpl::setStatus()
     * @uses GetResourceInventoryReportRequestImpl::setLimit()
     * @uses GetResourceInventoryReportRequestImpl::setStartRow()
     * @uses GetResourceInventoryReportRequestImpl::setSubmarket()
     * @uses GetResourceInventoryReportRequestImpl::setGwGlobal()
     * @param string $serviceType
     * @param string $type
     * @param string $status
     * @param int $limit
     * @param int $startRow
     * @param string $submarket
     * @param string $gwGlobal
     */
    public function __construct($serviceType = null, $type = null, $status = null, $limit = null, $startRow = null, $submarket = null, $gwGlobal = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setType($type)
            ->setStatus($status)
            ->setLimit($limit)
            ->setStartRow($startRow)
            ->setSubmarket($submarket)
            ->setGwGlobal($gwGlobal);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ResourceInventoryTypeEnum::valueIsValid()
     * @uses \EnumType\ResourceInventoryTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ResourceInventoryTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ResourceInventoryTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Get submarket value
     * @return string|null
     */
    public function getSubmarket()
    {
        return $this->submarket;
    }
    /**
     * Set submarket value
     * @param string $submarket
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setSubmarket($submarket = null)
    {
        // validation for constraint: string
        if (!is_null($submarket) && !is_string($submarket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarket)), __LINE__);
        }
        $this->submarket = $submarket;
        return $this;
    }
    /**
     * Get gwGlobal value
     * @return string|null
     */
    public function getGwGlobal()
    {
        return $this->gwGlobal;
    }
    /**
     * Set gwGlobal value
     * @param string $gwGlobal
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public function setGwGlobal($gwGlobal = null)
    {
        // validation for constraint: string
        if (!is_null($gwGlobal) && !is_string($gwGlobal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gwGlobal)), __LINE__);
        }
        $this->gwGlobal = $gwGlobal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetResourceInventoryReportRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
