<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrepaidAccountSummaryRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getPrepaidAccountSummaryRequestImpl
 * @subpackage Structs
 */
class GetPrepaidAccountSummaryRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The prepaidAccountType
     * @var string
     */
    public $prepaidAccountType;
    /**
     * The subscriberItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberItem;
    /**
     * The servicePlan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $servicePlan;
    /**
     * The createdDateStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDateStart;
    /**
     * The createdDateEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDateEnd;
    /**
     * The expiryDateStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expiryDateStart;
    /**
     * The expiryDateEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expiryDateEnd;
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $balance;
    /**
     * The balanceOperator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $balanceOperator;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for getPrepaidAccountSummaryRequestImpl
     * @uses GetPrepaidAccountSummaryRequestImpl::setPrepaidAccountType()
     * @uses GetPrepaidAccountSummaryRequestImpl::setSubscriberItem()
     * @uses GetPrepaidAccountSummaryRequestImpl::setServicePlan()
     * @uses GetPrepaidAccountSummaryRequestImpl::setCreatedDateStart()
     * @uses GetPrepaidAccountSummaryRequestImpl::setCreatedDateEnd()
     * @uses GetPrepaidAccountSummaryRequestImpl::setExpiryDateStart()
     * @uses GetPrepaidAccountSummaryRequestImpl::setExpiryDateEnd()
     * @uses GetPrepaidAccountSummaryRequestImpl::setBalance()
     * @uses GetPrepaidAccountSummaryRequestImpl::setBalanceOperator()
     * @uses GetPrepaidAccountSummaryRequestImpl::setLimit()
     * @uses GetPrepaidAccountSummaryRequestImpl::setStartRow()
     * @param string $prepaidAccountType
     * @param string $subscriberItem
     * @param string $servicePlan
     * @param string $createdDateStart
     * @param string $createdDateEnd
     * @param string $expiryDateStart
     * @param string $expiryDateEnd
     * @param string $balance
     * @param string $balanceOperator
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($prepaidAccountType = null, $subscriberItem = null, $servicePlan = null, $createdDateStart = null, $createdDateEnd = null, $expiryDateStart = null, $expiryDateEnd = null, $balance = null, $balanceOperator = null, $limit = null, $startRow = null)
    {
        $this
            ->setPrepaidAccountType($prepaidAccountType)
            ->setSubscriberItem($subscriberItem)
            ->setServicePlan($servicePlan)
            ->setCreatedDateStart($createdDateStart)
            ->setCreatedDateEnd($createdDateEnd)
            ->setExpiryDateStart($expiryDateStart)
            ->setExpiryDateEnd($expiryDateEnd)
            ->setBalance($balance)
            ->setBalanceOperator($balanceOperator)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get prepaidAccountType value
     * @return string|null
     */
    public function getPrepaidAccountType()
    {
        return $this->prepaidAccountType;
    }
    /**
     * Set prepaidAccountType value
     * @uses \EnumType\PrepaidAccountTypeEnum::valueIsValid()
     * @uses \EnumType\PrepaidAccountTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prepaidAccountType
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setPrepaidAccountType($prepaidAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrepaidAccountTypeEnum::valueIsValid($prepaidAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $prepaidAccountType, implode(', ', \EnumType\PrepaidAccountTypeEnum::getValidValues())), __LINE__);
        }
        $this->prepaidAccountType = $prepaidAccountType;
        return $this;
    }
    /**
     * Get subscriberItem value
     * @return string|null
     */
    public function getSubscriberItem()
    {
        return $this->subscriberItem;
    }
    /**
     * Set subscriberItem value
     * @param string $subscriberItem
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setSubscriberItem($subscriberItem = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberItem) && !is_string($subscriberItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberItem)), __LINE__);
        }
        $this->subscriberItem = $subscriberItem;
        return $this;
    }
    /**
     * Get servicePlan value
     * @return string|null
     */
    public function getServicePlan()
    {
        return $this->servicePlan;
    }
    /**
     * Set servicePlan value
     * @param string $servicePlan
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setServicePlan($servicePlan = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlan) && !is_string($servicePlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlan)), __LINE__);
        }
        $this->servicePlan = $servicePlan;
        return $this;
    }
    /**
     * Get createdDateStart value
     * @return string|null
     */
    public function getCreatedDateStart()
    {
        return $this->createdDateStart;
    }
    /**
     * Set createdDateStart value
     * @param string $createdDateStart
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setCreatedDateStart($createdDateStart = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateStart) && !is_string($createdDateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDateStart)), __LINE__);
        }
        $this->createdDateStart = $createdDateStart;
        return $this;
    }
    /**
     * Get createdDateEnd value
     * @return string|null
     */
    public function getCreatedDateEnd()
    {
        return $this->createdDateEnd;
    }
    /**
     * Set createdDateEnd value
     * @param string $createdDateEnd
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setCreatedDateEnd($createdDateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($createdDateEnd) && !is_string($createdDateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDateEnd)), __LINE__);
        }
        $this->createdDateEnd = $createdDateEnd;
        return $this;
    }
    /**
     * Get expiryDateStart value
     * @return string|null
     */
    public function getExpiryDateStart()
    {
        return $this->expiryDateStart;
    }
    /**
     * Set expiryDateStart value
     * @param string $expiryDateStart
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setExpiryDateStart($expiryDateStart = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateStart) && !is_string($expiryDateStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDateStart)), __LINE__);
        }
        $this->expiryDateStart = $expiryDateStart;
        return $this;
    }
    /**
     * Get expiryDateEnd value
     * @return string|null
     */
    public function getExpiryDateEnd()
    {
        return $this->expiryDateEnd;
    }
    /**
     * Set expiryDateEnd value
     * @param string $expiryDateEnd
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setExpiryDateEnd($expiryDateEnd = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateEnd) && !is_string($expiryDateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDateEnd)), __LINE__);
        }
        $this->expiryDateEnd = $expiryDateEnd;
        return $this;
    }
    /**
     * Get balance value
     * @return string|null
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param string $balance
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: string
        if (!is_null($balance) && !is_string($balance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balance)), __LINE__);
        }
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get balanceOperator value
     * @return string|null
     */
    public function getBalanceOperator()
    {
        return $this->balanceOperator;
    }
    /**
     * Set balanceOperator value
     * @param string $balanceOperator
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setBalanceOperator($balanceOperator = null)
    {
        // validation for constraint: string
        if (!is_null($balanceOperator) && !is_string($balanceOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceOperator)), __LINE__);
        }
        $this->balanceOperator = $balanceOperator;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public function setStartRow($startRow = null)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPrepaidAccountSummaryRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
