<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getModelsRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getModelsRequestImpl
 * @subpackage Structs
 */
class GetModelsRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The manufacturerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerId;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The modelNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modelNumber;
    /**
     * The verticalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $verticalId;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for getModelsRequestImpl
     * @uses GetModelsRequestImpl::setManufacturerId()
     * @uses GetModelsRequestImpl::setName()
     * @uses GetModelsRequestImpl::setModelNumber()
     * @uses GetModelsRequestImpl::setVerticalId()
     * @uses GetModelsRequestImpl::setStatus()
     * @param string $manufacturerId
     * @param string $name
     * @param string $modelNumber
     * @param string $verticalId
     * @param string $status
     */
    public function __construct($manufacturerId = null, $name = null, $modelNumber = null, $verticalId = null, $status = null)
    {
        $this
            ->setManufacturerId($manufacturerId)
            ->setName($name)
            ->setModelNumber($modelNumber)
            ->setVerticalId($verticalId)
            ->setStatus($status);
    }
    /**
     * Get manufacturerId value
     * @return string|null
     */
    public function getManufacturerId()
    {
        return $this->manufacturerId;
    }
    /**
     * Set manufacturerId value
     * @param string $manufacturerId
     * @return \StructType\GetModelsRequestImpl
     */
    public function setManufacturerId($manufacturerId = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerId) && !is_string($manufacturerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturerId)), __LINE__);
        }
        $this->manufacturerId = $manufacturerId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\GetModelsRequestImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get modelNumber value
     * @return string|null
     */
    public function getModelNumber()
    {
        return $this->modelNumber;
    }
    /**
     * Set modelNumber value
     * @param string $modelNumber
     * @return \StructType\GetModelsRequestImpl
     */
    public function setModelNumber($modelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modelNumber) && !is_string($modelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelNumber)), __LINE__);
        }
        $this->modelNumber = $modelNumber;
        return $this;
    }
    /**
     * Get verticalId value
     * @return string|null
     */
    public function getVerticalId()
    {
        return $this->verticalId;
    }
    /**
     * Set verticalId value
     * @param string $verticalId
     * @return \StructType\GetModelsRequestImpl
     */
    public function setVerticalId($verticalId = null)
    {
        // validation for constraint: string
        if (!is_null($verticalId) && !is_string($verticalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($verticalId)), __LINE__);
        }
        $this->verticalId = $verticalId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ObjectStatusEnum::valueIsValid()
     * @uses \EnumType\ObjectStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\GetModelsRequestImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObjectStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ObjectStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetModelsRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
