<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findUserProfilesRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:findUserProfilesRequestImpl
 * @subpackage Structs
 */
class FindUserProfilesRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $role;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * Constructor method for findUserProfilesRequestImpl
     * @uses FindUserProfilesRequestImpl::setUserName()
     * @uses FindUserProfilesRequestImpl::setRole()
     * @uses FindUserProfilesRequestImpl::setStatus()
     * @param string $userName
     * @param string $role
     * @param string $status
     */
    public function __construct($userName = null, $role = null, $status = null)
    {
        $this
            ->setUserName($userName)
            ->setRole($role)
            ->setStatus($status);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\FindUserProfilesRequestImpl
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \EnumType\RoleTypeEnum::valueIsValid()
     * @uses \EnumType\RoleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \StructType\FindUserProfilesRequestImpl
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleTypeEnum::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $role, implode(', ', \EnumType\RoleTypeEnum::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\UserStatusEnum::valueIsValid()
     * @uses \EnumType\UserStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\FindUserProfilesRequestImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\UserStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FindUserProfilesRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
