<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for failureList StructType
 * @subpackage Structs
 */
class FailureList extends AbstractStructBase
{
    /**
     * The failureEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProvisioningFailureEntryImpl[]
     */
    public $failureEntry;
    /**
     * Constructor method for failureList
     * @uses FailureList::setFailureEntry()
     * @param \StructType\ProvisioningFailureEntryImpl[] $failureEntry
     */
    public function __construct(array $failureEntry = array())
    {
        $this
            ->setFailureEntry($failureEntry);
    }
    /**
     * Get failureEntry value
     * @return \StructType\ProvisioningFailureEntryImpl[]|null
     */
    public function getFailureEntry()
    {
        return $this->failureEntry;
    }
    /**
     * Set failureEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ProvisioningFailureEntryImpl[] $failureEntry
     * @return \StructType\FailureList
     */
    public function setFailureEntry(array $failureEntry = array())
    {
        foreach ($failureEntry as $failureListFailureEntryItem) {
            // validation for constraint: itemType
            if (!$failureListFailureEntryItem instanceof \StructType\ProvisioningFailureEntryImpl) {
                throw new \InvalidArgumentException(sprintf('The failureEntry property can only contain items of \StructType\ProvisioningFailureEntryImpl, "%s" given', is_object($failureListFailureEntryItem) ? get_class($failureListFailureEntryItem) : gettype($failureListFailureEntryItem)), __LINE__);
            }
        }
        $this->failureEntry = $failureEntry;
        return $this;
    }
    /**
     * Add item to failureEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\ProvisioningFailureEntryImpl $item
     * @return \StructType\FailureList
     */
    public function addToFailureEntry(\StructType\ProvisioningFailureEntryImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProvisioningFailureEntryImpl) {
            throw new \InvalidArgumentException(sprintf('The failureEntry property can only contain items of \StructType\ProvisioningFailureEntryImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->failureEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FailureList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
