<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deliveryDestinationImpl StructType
 * @subpackage Structs
 */
class DeliveryDestinationImpl extends AbstractStructBase
{
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $destination;
    /**
     * The deliveryMethod
     * @var string
     */
    public $deliveryMethod;
    /**
     * The geoDataFlag
     * @var string
     */
    public $geoDataFlag;
    /**
     * The moAckFlag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $moAckFlag;
    /**
     * Constructor method for deliveryDestinationImpl
     * @uses DeliveryDestinationImpl::setDestination()
     * @uses DeliveryDestinationImpl::setDeliveryMethod()
     * @uses DeliveryDestinationImpl::setGeoDataFlag()
     * @uses DeliveryDestinationImpl::setMoAckFlag()
     * @param string $destination
     * @param string $deliveryMethod
     * @param string $geoDataFlag
     * @param string $moAckFlag
     */
    public function __construct($destination = null, $deliveryMethod = null, $geoDataFlag = null, $moAckFlag = null)
    {
        $this
            ->setDestination($destination)
            ->setDeliveryMethod($deliveryMethod)
            ->setGeoDataFlag($geoDataFlag)
            ->setMoAckFlag($moAckFlag);
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\DeliveryDestinationImpl
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get deliveryMethod value
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->deliveryMethod;
    }
    /**
     * Set deliveryMethod value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethod
     * @return \StructType\DeliveryDestinationImpl
     */
    public function setDeliveryMethod($deliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($deliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethod, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get geoDataFlag value
     * @return string|null
     */
    public function getGeoDataFlag()
    {
        return $this->geoDataFlag;
    }
    /**
     * Set geoDataFlag value
     * @param string $geoDataFlag
     * @return \StructType\DeliveryDestinationImpl
     */
    public function setGeoDataFlag($geoDataFlag = null)
    {
        // validation for constraint: string
        if (!is_null($geoDataFlag) && !is_string($geoDataFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geoDataFlag)), __LINE__);
        }
        $this->geoDataFlag = $geoDataFlag;
        return $this;
    }
    /**
     * Get moAckFlag value
     * @return string|null
     */
    public function getMoAckFlag()
    {
        return $this->moAckFlag;
    }
    /**
     * Set moAckFlag value
     * @param string $moAckFlag
     * @return \StructType\DeliveryDestinationImpl
     */
    public function setMoAckFlag($moAckFlag = null)
    {
        // validation for constraint: string
        if (!is_null($moAckFlag) && !is_string($moAckFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moAckFlag)), __LINE__);
        }
        $this->moAckFlag = $moAckFlag;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryDestinationImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
