<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for datBundleInfoImpl StructType
 * @subpackage Structs
 */
class DatBundleInfoImpl extends BundleInfoImpl
{
    /**
     * The numAvailable
     * @var int
     */
    public $numAvailable;
    /**
     * The datType
     * @var string
     */
    public $datType;
    /**
     * Constructor method for datBundleInfoImpl
     * @uses DatBundleInfoImpl::setNumAvailable()
     * @uses DatBundleInfoImpl::setDatType()
     * @param int $numAvailable
     * @param string $datType
     */
    public function __construct($numAvailable = null, $datType = null)
    {
        $this
            ->setNumAvailable($numAvailable)
            ->setDatType($datType);
    }
    /**
     * Get numAvailable value
     * @return int|null
     */
    public function getNumAvailable()
    {
        return $this->numAvailable;
    }
    /**
     * Set numAvailable value
     * @param int $numAvailable
     * @return \StructType\DatBundleInfoImpl
     */
    public function setNumAvailable($numAvailable = null)
    {
        // validation for constraint: int
        if (!is_null($numAvailable) && !is_numeric($numAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numAvailable)), __LINE__);
        }
        $this->numAvailable = $numAvailable;
        return $this;
    }
    /**
     * Get datType value
     * @return string|null
     */
    public function getDatType()
    {
        return $this->datType;
    }
    /**
     * Set datType value
     * @uses \EnumType\DatTypeEnum::valueIsValid()
     * @uses \EnumType\DatTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $datType
     * @return \StructType\DatBundleInfoImpl
     */
    public function setDatType($datType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatTypeEnum::valueIsValid($datType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $datType, implode(', ', \EnumType\DatTypeEnum::getValidValues())), __LINE__);
        }
        $this->datType = $datType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DatBundleInfoImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
