<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for contactInfoImpl StructType
 * @subpackage Structs
 */
class ContactInfoImpl extends AbstractStructBase
{
    /**
     * The salutation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salutation;
    /**
     * The company
     * @var string
     */
    public $company;
    /**
     * The firstName
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * @var string
     */
    public $lastName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The state
     * @var string
     */
    public $state;
    /**
     * The postalCode
     * @var string
     */
    public $postalCode;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The contactType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactType;
    /**
     * Constructor method for contactInfoImpl
     * @uses ContactInfoImpl::setSalutation()
     * @uses ContactInfoImpl::setCompany()
     * @uses ContactInfoImpl::setFirstName()
     * @uses ContactInfoImpl::setLastName()
     * @uses ContactInfoImpl::setMiddleName()
     * @uses ContactInfoImpl::setAddress()
     * @uses ContactInfoImpl::setCity()
     * @uses ContactInfoImpl::setState()
     * @uses ContactInfoImpl::setPostalCode()
     * @uses ContactInfoImpl::setCountry()
     * @uses ContactInfoImpl::setEmail()
     * @uses ContactInfoImpl::setPhone()
     * @uses ContactInfoImpl::setContactType()
     * @param string $salutation
     * @param string $company
     * @param string $firstName
     * @param string $lastName
     * @param string $middleName
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $postalCode
     * @param string $country
     * @param string $email
     * @param string $phone
     * @param string $contactType
     */
    public function __construct($salutation = null, $company = null, $firstName = null, $lastName = null, $middleName = null, $address = null, $city = null, $state = null, $postalCode = null, $country = null, $email = null, $phone = null, $contactType = null)
    {
        $this
            ->setSalutation($salutation)
            ->setCompany($company)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setPostalCode($postalCode)
            ->setCountry($country)
            ->setEmail($email)
            ->setPhone($phone)
            ->setContactType($contactType);
    }
    /**
     * Get salutation value
     * @return string|null
     */
    public function getSalutation()
    {
        return $this->salutation;
    }
    /**
     * Set salutation value
     * @param string $salutation
     * @return \StructType\ContactInfoImpl
     */
    public function setSalutation($salutation = null)
    {
        // validation for constraint: string
        if (!is_null($salutation) && !is_string($salutation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salutation)), __LINE__);
        }
        $this->salutation = $salutation;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \StructType\ContactInfoImpl
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \StructType\ContactInfoImpl
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \StructType\ContactInfoImpl
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \StructType\ContactInfoImpl
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\ContactInfoImpl
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\ContactInfoImpl
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\ContactInfoImpl
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get postalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->postalCode;
    }
    /**
     * Set postalCode value
     * @param string $postalCode
     * @return \StructType\ContactInfoImpl
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->postalCode = $postalCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\ContactInfoImpl
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\ContactInfoImpl
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\ContactInfoImpl
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get contactType value
     * @return string|null
     */
    public function getContactType()
    {
        return $this->contactType;
    }
    /**
     * Set contactType value
     * @uses \EnumType\ContactTypeEnum::valueIsValid()
     * @uses \EnumType\ContactTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contactType
     * @return \StructType\ContactInfoImpl
     */
    public function setContactType($contactType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ContactTypeEnum::valueIsValid($contactType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contactType, implode(', ', \EnumType\ContactTypeEnum::getValidValues())), __LINE__);
        }
        $this->contactType = $contactType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactInfoImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
