<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for certusDeviceNumberImpl StructType
 * @subpackage Structs
 */
class CertusDeviceNumberImpl extends DeviceImpl
{
    /**
     * The submarketId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarketId;
    /**
     * The network
     * @var string
     */
    public $network;
    /**
     * The lineNum
     * @var int
     */
    public $lineNum;
    /**
     * The lineType
     * @var string
     */
    public $lineType;
    /**
     * The lineQuality
     * @var string
     */
    public $lineQuality;
    /**
     * The voiceMail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $voiceMail;
    /**
     * The captainPinEnable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $captainPinEnable;
    /**
     * The captainPin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $captainPin;
    /**
     * The twoStageEnable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $twoStageEnable;
    /**
     * The twoStagePin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $twoStagePin;
    /**
     * The enableLocalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $enableLocalNumber;
    /**
     * The localCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $localCountry;
    /**
     * The localNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocalNumImpl
     */
    public $localNumber;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The primarySafety
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $primarySafety;
    /**
     * Constructor method for certusDeviceNumberImpl
     * @uses CertusDeviceNumberImpl::setSubmarketId()
     * @uses CertusDeviceNumberImpl::setNetwork()
     * @uses CertusDeviceNumberImpl::setLineNum()
     * @uses CertusDeviceNumberImpl::setLineType()
     * @uses CertusDeviceNumberImpl::setLineQuality()
     * @uses CertusDeviceNumberImpl::setVoiceMail()
     * @uses CertusDeviceNumberImpl::setCaptainPinEnable()
     * @uses CertusDeviceNumberImpl::setCaptainPin()
     * @uses CertusDeviceNumberImpl::setTwoStageEnable()
     * @uses CertusDeviceNumberImpl::setTwoStagePin()
     * @uses CertusDeviceNumberImpl::setEnableLocalNumber()
     * @uses CertusDeviceNumberImpl::setLocalCountry()
     * @uses CertusDeviceNumberImpl::setLocalNumber()
     * @uses CertusDeviceNumberImpl::setLanguage()
     * @uses CertusDeviceNumberImpl::setPrimarySafety()
     * @param string $submarketId
     * @param string $network
     * @param int $lineNum
     * @param string $lineType
     * @param string $lineQuality
     * @param string $voiceMail
     * @param string $captainPinEnable
     * @param string $captainPin
     * @param string $twoStageEnable
     * @param string $twoStagePin
     * @param string $enableLocalNumber
     * @param string $localCountry
     * @param \StructType\LocalNumImpl $localNumber
     * @param string $language
     * @param string $primarySafety
     */
    public function __construct($submarketId = null, $network = null, $lineNum = null, $lineType = null, $lineQuality = null, $voiceMail = null, $captainPinEnable = null, $captainPin = null, $twoStageEnable = null, $twoStagePin = null, $enableLocalNumber = null, $localCountry = null, \StructType\LocalNumImpl $localNumber = null, $language = null, $primarySafety = null)
    {
        $this
            ->setSubmarketId($submarketId)
            ->setNetwork($network)
            ->setLineNum($lineNum)
            ->setLineType($lineType)
            ->setLineQuality($lineQuality)
            ->setVoiceMail($voiceMail)
            ->setCaptainPinEnable($captainPinEnable)
            ->setCaptainPin($captainPin)
            ->setTwoStageEnable($twoStageEnable)
            ->setTwoStagePin($twoStagePin)
            ->setEnableLocalNumber($enableLocalNumber)
            ->setLocalCountry($localCountry)
            ->setLocalNumber($localNumber)
            ->setLanguage($language)
            ->setPrimarySafety($primarySafety);
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Get network value
     * @return string|null
     */
    public function getNetwork()
    {
        return $this->network;
    }
    /**
     * Set network value
     * @param string $network
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setNetwork($network = null)
    {
        // validation for constraint: string
        if (!is_null($network) && !is_string($network)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($network)), __LINE__);
        }
        $this->network = $network;
        return $this;
    }
    /**
     * Get lineNum value
     * @return int|null
     */
    public function getLineNum()
    {
        return $this->lineNum;
    }
    /**
     * Set lineNum value
     * @param int $lineNum
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setLineNum($lineNum = null)
    {
        // validation for constraint: int
        if (!is_null($lineNum) && !is_numeric($lineNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNum)), __LINE__);
        }
        $this->lineNum = $lineNum;
        return $this;
    }
    /**
     * Get lineType value
     * @return string|null
     */
    public function getLineType()
    {
        return $this->lineType;
    }
    /**
     * Set lineType value
     * @uses \EnumType\CertusLineTypeEnum::valueIsValid()
     * @uses \EnumType\CertusLineTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineType
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CertusLineTypeEnum::valueIsValid($lineType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lineType, implode(', ', \EnumType\CertusLineTypeEnum::getValidValues())), __LINE__);
        }
        $this->lineType = $lineType;
        return $this;
    }
    /**
     * Get lineQuality value
     * @return string|null
     */
    public function getLineQuality()
    {
        return $this->lineQuality;
    }
    /**
     * Set lineQuality value
     * @uses \EnumType\LineQualityEnum::valueIsValid()
     * @uses \EnumType\LineQualityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineQuality
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setLineQuality($lineQuality = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LineQualityEnum::valueIsValid($lineQuality)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lineQuality, implode(', ', \EnumType\LineQualityEnum::getValidValues())), __LINE__);
        }
        $this->lineQuality = $lineQuality;
        return $this;
    }
    /**
     * Get voiceMail value
     * @return string|null
     */
    public function getVoiceMail()
    {
        return $this->voiceMail;
    }
    /**
     * Set voiceMail value
     * @param string $voiceMail
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setVoiceMail($voiceMail = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMail) && !is_string($voiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMail)), __LINE__);
        }
        $this->voiceMail = $voiceMail;
        return $this;
    }
    /**
     * Get captainPinEnable value
     * @return string|null
     */
    public function getCaptainPinEnable()
    {
        return $this->captainPinEnable;
    }
    /**
     * Set captainPinEnable value
     * @param string $captainPinEnable
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setCaptainPinEnable($captainPinEnable = null)
    {
        // validation for constraint: string
        if (!is_null($captainPinEnable) && !is_string($captainPinEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($captainPinEnable)), __LINE__);
        }
        $this->captainPinEnable = $captainPinEnable;
        return $this;
    }
    /**
     * Get captainPin value
     * @return string|null
     */
    public function getCaptainPin()
    {
        return $this->captainPin;
    }
    /**
     * Set captainPin value
     * @param string $captainPin
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setCaptainPin($captainPin = null)
    {
        // validation for constraint: string
        if (!is_null($captainPin) && !is_string($captainPin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($captainPin)), __LINE__);
        }
        $this->captainPin = $captainPin;
        return $this;
    }
    /**
     * Get twoStageEnable value
     * @return string|null
     */
    public function getTwoStageEnable()
    {
        return $this->twoStageEnable;
    }
    /**
     * Set twoStageEnable value
     * @param string $twoStageEnable
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setTwoStageEnable($twoStageEnable = null)
    {
        // validation for constraint: string
        if (!is_null($twoStageEnable) && !is_string($twoStageEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twoStageEnable)), __LINE__);
        }
        $this->twoStageEnable = $twoStageEnable;
        return $this;
    }
    /**
     * Get twoStagePin value
     * @return string|null
     */
    public function getTwoStagePin()
    {
        return $this->twoStagePin;
    }
    /**
     * Set twoStagePin value
     * @param string $twoStagePin
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setTwoStagePin($twoStagePin = null)
    {
        // validation for constraint: string
        if (!is_null($twoStagePin) && !is_string($twoStagePin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twoStagePin)), __LINE__);
        }
        $this->twoStagePin = $twoStagePin;
        return $this;
    }
    /**
     * Get enableLocalNumber value
     * @return string|null
     */
    public function getEnableLocalNumber()
    {
        return $this->enableLocalNumber;
    }
    /**
     * Set enableLocalNumber value
     * @param string $enableLocalNumber
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setEnableLocalNumber($enableLocalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($enableLocalNumber) && !is_string($enableLocalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableLocalNumber)), __LINE__);
        }
        $this->enableLocalNumber = $enableLocalNumber;
        return $this;
    }
    /**
     * Get localCountry value
     * @return string|null
     */
    public function getLocalCountry()
    {
        return $this->localCountry;
    }
    /**
     * Set localCountry value
     * @param string $localCountry
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setLocalCountry($localCountry = null)
    {
        // validation for constraint: string
        if (!is_null($localCountry) && !is_string($localCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localCountry)), __LINE__);
        }
        $this->localCountry = $localCountry;
        return $this;
    }
    /**
     * Get localNumber value
     * @return \StructType\LocalNumImpl|null
     */
    public function getLocalNumber()
    {
        return $this->localNumber;
    }
    /**
     * Set localNumber value
     * @param \StructType\LocalNumImpl $localNumber
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setLocalNumber(\StructType\LocalNumImpl $localNumber = null)
    {
        $this->localNumber = $localNumber;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get primarySafety value
     * @return string|null
     */
    public function getPrimarySafety()
    {
        return $this->primarySafety;
    }
    /**
     * Set primarySafety value
     * @param string $primarySafety
     * @return \StructType\CertusDeviceNumberImpl
     */
    public function setPrimarySafety($primarySafety = null)
    {
        // validation for constraint: string
        if (!is_null($primarySafety) && !is_string($primarySafety)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primarySafety)), __LINE__);
        }
        $this->primarySafety = $primarySafety;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CertusDeviceNumberImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
