<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for calls StructType
 * @subpackage Structs
 */
class Calls extends AbstractStructBase
{
    /**
     * The call
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CallSummaryReportImpl[]
     */
    public $call;
    /**
     * Constructor method for calls
     * @uses Calls::setCall()
     * @param \StructType\CallSummaryReportImpl[] $call
     */
    public function __construct(array $call = array())
    {
        $this
            ->setCall($call);
    }
    /**
     * Get call value
     * @return \StructType\CallSummaryReportImpl[]|null
     */
    public function getCall()
    {
        return $this->call;
    }
    /**
     * Set call value
     * @throws \InvalidArgumentException
     * @param \StructType\CallSummaryReportImpl[] $call
     * @return \StructType\Calls
     */
    public function setCall(array $call = array())
    {
        foreach ($call as $callsCallItem) {
            // validation for constraint: itemType
            if (!$callsCallItem instanceof \StructType\CallSummaryReportImpl) {
                throw new \InvalidArgumentException(sprintf('The call property can only contain items of \StructType\CallSummaryReportImpl, "%s" given', is_object($callsCallItem) ? get_class($callsCallItem) : gettype($callsCallItem)), __LINE__);
            }
        }
        $this->call = $call;
        return $this;
    }
    /**
     * Add item to call value
     * @throws \InvalidArgumentException
     * @param \StructType\CallSummaryReportImpl $item
     * @return \StructType\Calls
     */
    public function addToCall(\StructType\CallSummaryReportImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallSummaryReportImpl) {
            throw new \InvalidArgumentException(sprintf('The call property can only contain items of \StructType\CallSummaryReportImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->call[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Calls
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
