<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callDataSearchCriteriaImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:callDataSearchCriteriaImpl
 * @subpackage Structs
 */
class CallDataSearchCriteriaImpl extends AbstractStructBase
{
    /**
     * The subscriberAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberAccountNumber;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The fromDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromDate;
    /**
     * The toDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $toDate;
    /**
     * Constructor method for callDataSearchCriteriaImpl
     * @uses CallDataSearchCriteriaImpl::setSubscriberAccountNumber()
     * @uses CallDataSearchCriteriaImpl::setType()
     * @uses CallDataSearchCriteriaImpl::setFromDate()
     * @uses CallDataSearchCriteriaImpl::setToDate()
     * @param string $subscriberAccountNumber
     * @param string $type
     * @param string $fromDate
     * @param string $toDate
     */
    public function __construct($subscriberAccountNumber = null, $type = null, $fromDate = null, $toDate = null)
    {
        $this
            ->setSubscriberAccountNumber($subscriberAccountNumber)
            ->setType($type)
            ->setFromDate($fromDate)
            ->setToDate($toDate);
    }
    /**
     * Get subscriberAccountNumber value
     * @return string|null
     */
    public function getSubscriberAccountNumber()
    {
        return $this->subscriberAccountNumber;
    }
    /**
     * Set subscriberAccountNumber value
     * @param string $subscriberAccountNumber
     * @return \StructType\CallDataSearchCriteriaImpl
     */
    public function setSubscriberAccountNumber($subscriberAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberAccountNumber) && !is_string($subscriberAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberAccountNumber)), __LINE__);
        }
        $this->subscriberAccountNumber = $subscriberAccountNumber;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\CallServiceCodeEnum::valueIsValid()
     * @uses \EnumType\CallServiceCodeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\CallDataSearchCriteriaImpl
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallServiceCodeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\CallServiceCodeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get fromDate value
     * @return string|null
     */
    public function getFromDate()
    {
        return $this->fromDate;
    }
    /**
     * Set fromDate value
     * @param string $fromDate
     * @return \StructType\CallDataSearchCriteriaImpl
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->fromDate = $fromDate;
        return $this;
    }
    /**
     * Get toDate value
     * @return string|null
     */
    public function getToDate()
    {
        return $this->toDate;
    }
    /**
     * Set toDate value
     * @param string $toDate
     * @return \StructType\CallDataSearchCriteriaImpl
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->toDate = $toDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallDataSearchCriteriaImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
