<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callDataEntryImpl StructType
 * @subpackage Structs
 */
class CallDataEntryImpl extends AbstractStructBase
{
    /**
     * The callId
     * @var string
     */
    public $callId;
    /**
     * The serviceId
     * @var int
     */
    public $serviceId;
    /**
     * The accountId
     * @var int
     */
    public $accountId;
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The serviceProviderAccountId
     * @var int
     */
    public $serviceProviderAccountId;
    /**
     * The serviceProviderAccountNumber
     * @var string
     */
    public $serviceProviderAccountNumber;
    /**
     * The msisdn
     * @var string
     */
    public $msisdn;
    /**
     * The duration
     * @var int
     */
    public $duration;
    /**
     * The totalBytes
     * @var int
     */
    public $totalBytes;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The imei
     * @var string
     */
    public $imei;
    /**
     * The imsi
     * @var string
     */
    public $imsi;
    /**
     * The direction
     * @var string
     */
    public $direction;
    /**
     * The startTime
     * @var string
     */
    public $startTime;
    /**
     * The endTime
     * @var string
     */
    public $endTime;
    /**
     * The ipAddress
     * @var string
     */
    public $ipAddress;
    /**
     * The serviceCode
     * @var string
     */
    public $serviceCode;
    /**
     * The callingFrom
     * @var string
     */
    public $callingFrom;
    /**
     * The callingTo
     * @var string
     */
    public $callingTo;
    /**
     * The location
     * @var string
     */
    public $location;
    /**
     * The supplementaryService
     * @var int
     */
    public $supplementaryService;
    /**
     * Constructor method for callDataEntryImpl
     * @uses CallDataEntryImpl::setCallId()
     * @uses CallDataEntryImpl::setServiceId()
     * @uses CallDataEntryImpl::setAccountId()
     * @uses CallDataEntryImpl::setAccountNumber()
     * @uses CallDataEntryImpl::setServiceProviderAccountId()
     * @uses CallDataEntryImpl::setServiceProviderAccountNumber()
     * @uses CallDataEntryImpl::setMsisdn()
     * @uses CallDataEntryImpl::setDuration()
     * @uses CallDataEntryImpl::setTotalBytes()
     * @uses CallDataEntryImpl::setStatus()
     * @uses CallDataEntryImpl::setImei()
     * @uses CallDataEntryImpl::setImsi()
     * @uses CallDataEntryImpl::setDirection()
     * @uses CallDataEntryImpl::setStartTime()
     * @uses CallDataEntryImpl::setEndTime()
     * @uses CallDataEntryImpl::setIpAddress()
     * @uses CallDataEntryImpl::setServiceCode()
     * @uses CallDataEntryImpl::setCallingFrom()
     * @uses CallDataEntryImpl::setCallingTo()
     * @uses CallDataEntryImpl::setLocation()
     * @uses CallDataEntryImpl::setSupplementaryService()
     * @param string $callId
     * @param int $serviceId
     * @param int $accountId
     * @param string $accountNumber
     * @param int $serviceProviderAccountId
     * @param string $serviceProviderAccountNumber
     * @param string $msisdn
     * @param int $duration
     * @param int $totalBytes
     * @param string $status
     * @param string $imei
     * @param string $imsi
     * @param string $direction
     * @param string $startTime
     * @param string $endTime
     * @param string $ipAddress
     * @param string $serviceCode
     * @param string $callingFrom
     * @param string $callingTo
     * @param string $location
     * @param int $supplementaryService
     */
    public function __construct($callId = null, $serviceId = null, $accountId = null, $accountNumber = null, $serviceProviderAccountId = null, $serviceProviderAccountNumber = null, $msisdn = null, $duration = null, $totalBytes = null, $status = null, $imei = null, $imsi = null, $direction = null, $startTime = null, $endTime = null, $ipAddress = null, $serviceCode = null, $callingFrom = null, $callingTo = null, $location = null, $supplementaryService = null)
    {
        $this
            ->setCallId($callId)
            ->setServiceId($serviceId)
            ->setAccountId($accountId)
            ->setAccountNumber($accountNumber)
            ->setServiceProviderAccountId($serviceProviderAccountId)
            ->setServiceProviderAccountNumber($serviceProviderAccountNumber)
            ->setMsisdn($msisdn)
            ->setDuration($duration)
            ->setTotalBytes($totalBytes)
            ->setStatus($status)
            ->setImei($imei)
            ->setImsi($imsi)
            ->setDirection($direction)
            ->setStartTime($startTime)
            ->setEndTime($endTime)
            ->setIpAddress($ipAddress)
            ->setServiceCode($serviceCode)
            ->setCallingFrom($callingFrom)
            ->setCallingTo($callingTo)
            ->setLocation($location)
            ->setSupplementaryService($supplementaryService);
    }
    /**
     * Get callId value
     * @return string|null
     */
    public function getCallId()
    {
        return $this->callId;
    }
    /**
     * Set callId value
     * @param string $callId
     * @return \StructType\CallDataEntryImpl
     */
    public function setCallId($callId = null)
    {
        // validation for constraint: string
        if (!is_null($callId) && !is_string($callId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callId)), __LINE__);
        }
        $this->callId = $callId;
        return $this;
    }
    /**
     * Get serviceId value
     * @return int|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param int $serviceId
     * @return \StructType\CallDataEntryImpl
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceId) && !is_numeric($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get accountId value
     * @return int|null
     */
    public function getAccountId()
    {
        return $this->accountId;
    }
    /**
     * Set accountId value
     * @param int $accountId
     * @return \StructType\CallDataEntryImpl
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: int
        if (!is_null($accountId) && !is_numeric($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountId)), __LINE__);
        }
        $this->accountId = $accountId;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\CallDataEntryImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get serviceProviderAccountId value
     * @return int|null
     */
    public function getServiceProviderAccountId()
    {
        return $this->serviceProviderAccountId;
    }
    /**
     * Set serviceProviderAccountId value
     * @param int $serviceProviderAccountId
     * @return \StructType\CallDataEntryImpl
     */
    public function setServiceProviderAccountId($serviceProviderAccountId = null)
    {
        // validation for constraint: int
        if (!is_null($serviceProviderAccountId) && !is_numeric($serviceProviderAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceProviderAccountId)), __LINE__);
        }
        $this->serviceProviderAccountId = $serviceProviderAccountId;
        return $this;
    }
    /**
     * Get serviceProviderAccountNumber value
     * @return string|null
     */
    public function getServiceProviderAccountNumber()
    {
        return $this->serviceProviderAccountNumber;
    }
    /**
     * Set serviceProviderAccountNumber value
     * @param string $serviceProviderAccountNumber
     * @return \StructType\CallDataEntryImpl
     */
    public function setServiceProviderAccountNumber($serviceProviderAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderAccountNumber) && !is_string($serviceProviderAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderAccountNumber)), __LINE__);
        }
        $this->serviceProviderAccountNumber = $serviceProviderAccountNumber;
        return $this;
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return \StructType\CallDataEntryImpl
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msisdn)), __LINE__);
        }
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\CallDataEntryImpl
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get totalBytes value
     * @return int|null
     */
    public function getTotalBytes()
    {
        return $this->totalBytes;
    }
    /**
     * Set totalBytes value
     * @param int $totalBytes
     * @return \StructType\CallDataEntryImpl
     */
    public function setTotalBytes($totalBytes = null)
    {
        // validation for constraint: int
        if (!is_null($totalBytes) && !is_numeric($totalBytes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalBytes)), __LINE__);
        }
        $this->totalBytes = $totalBytes;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\CallStatusEnum::valueIsValid()
     * @uses \EnumType\CallStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\CallDataEntryImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\CallStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\CallDataEntryImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get imsi value
     * @return string|null
     */
    public function getImsi()
    {
        return $this->imsi;
    }
    /**
     * Set imsi value
     * @param string $imsi
     * @return \StructType\CallDataEntryImpl
     */
    public function setImsi($imsi = null)
    {
        // validation for constraint: string
        if (!is_null($imsi) && !is_string($imsi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imsi)), __LINE__);
        }
        $this->imsi = $imsi;
        return $this;
    }
    /**
     * Get direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @uses \EnumType\CallDirectionEnum::valueIsValid()
     * @uses \EnumType\CallDirectionEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\CallDataEntryImpl
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallDirectionEnum::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $direction, implode(', ', \EnumType\CallDirectionEnum::getValidValues())), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get startTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @param string $startTime
     * @return \StructType\CallDataEntryImpl
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get endTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param string $endTime
     * @return \StructType\CallDataEntryImpl
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \StructType\CallDataEntryImpl
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get serviceCode value
     * @return string|null
     */
    public function getServiceCode()
    {
        return $this->serviceCode;
    }
    /**
     * Set serviceCode value
     * @uses \EnumType\CallServiceCodeEnum::valueIsValid()
     * @uses \EnumType\CallServiceCodeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceCode
     * @return \StructType\CallDataEntryImpl
     */
    public function setServiceCode($serviceCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CallServiceCodeEnum::valueIsValid($serviceCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceCode, implode(', ', \EnumType\CallServiceCodeEnum::getValidValues())), __LINE__);
        }
        $this->serviceCode = $serviceCode;
        return $this;
    }
    /**
     * Get callingFrom value
     * @return string|null
     */
    public function getCallingFrom()
    {
        return $this->callingFrom;
    }
    /**
     * Set callingFrom value
     * @param string $callingFrom
     * @return \StructType\CallDataEntryImpl
     */
    public function setCallingFrom($callingFrom = null)
    {
        // validation for constraint: string
        if (!is_null($callingFrom) && !is_string($callingFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingFrom)), __LINE__);
        }
        $this->callingFrom = $callingFrom;
        return $this;
    }
    /**
     * Get callingTo value
     * @return string|null
     */
    public function getCallingTo()
    {
        return $this->callingTo;
    }
    /**
     * Set callingTo value
     * @param string $callingTo
     * @return \StructType\CallDataEntryImpl
     */
    public function setCallingTo($callingTo = null)
    {
        // validation for constraint: string
        if (!is_null($callingTo) && !is_string($callingTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingTo)), __LINE__);
        }
        $this->callingTo = $callingTo;
        return $this;
    }
    /**
     * Get location value
     * @return string|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param string $location
     * @return \StructType\CallDataEntryImpl
     */
    public function setLocation($location = null)
    {
        // validation for constraint: string
        if (!is_null($location) && !is_string($location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($location)), __LINE__);
        }
        $this->location = $location;
        return $this;
    }
    /**
     * Get supplementaryService value
     * @return int|null
     */
    public function getSupplementaryService()
    {
        return $this->supplementaryService;
    }
    /**
     * Set supplementaryService value
     * @param int $supplementaryService
     * @return \StructType\CallDataEntryImpl
     */
    public function setSupplementaryService($supplementaryService = null)
    {
        // validation for constraint: int
        if (!is_null($supplementaryService) && !is_numeric($supplementaryService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplementaryService)), __LINE__);
        }
        $this->supplementaryService = $supplementaryService;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallDataEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
