<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bulkBundleInfoImpl StructType
 * @subpackage Structs
 */
class BulkBundleInfoImpl extends BundleInfoImpl
{
    /**
     * The packQuantity
     * @var int
     */
    public $packQuantity;
    /**
     * Constructor method for bulkBundleInfoImpl
     * @uses BulkBundleInfoImpl::setPackQuantity()
     * @param int $packQuantity
     */
    public function __construct($packQuantity = null)
    {
        $this
            ->setPackQuantity($packQuantity);
    }
    /**
     * Get packQuantity value
     * @return int|null
     */
    public function getPackQuantity()
    {
        return $this->packQuantity;
    }
    /**
     * Set packQuantity value
     * @param int $packQuantity
     * @return \StructType\BulkBundleInfoImpl
     */
    public function setPackQuantity($packQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($packQuantity) && !is_numeric($packQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packQuantity)), __LINE__);
        }
        $this->packQuantity = $packQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BulkBundleInfoImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
