<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bulkActionSearchResultsImpl StructType
 * @subpackage Structs
 */
class BulkActionSearchResultsImpl extends AbstractStructBase
{
    /**
     * The bulkActions
     * @var \StructType\BulkActions
     */
    public $bulkActions;
    /**
     * The configuredResultLimit
     * @var int
     */
    public $configuredResultLimit;
    /**
     * The totalResultCount
     * @var int
     */
    public $totalResultCount;
    /**
     * Constructor method for bulkActionSearchResultsImpl
     * @uses BulkActionSearchResultsImpl::setBulkActions()
     * @uses BulkActionSearchResultsImpl::setConfiguredResultLimit()
     * @uses BulkActionSearchResultsImpl::setTotalResultCount()
     * @param \StructType\BulkActions $bulkActions
     * @param int $configuredResultLimit
     * @param int $totalResultCount
     */
    public function __construct(\StructType\BulkActions $bulkActions = null, $configuredResultLimit = null, $totalResultCount = null)
    {
        $this
            ->setBulkActions($bulkActions)
            ->setConfiguredResultLimit($configuredResultLimit)
            ->setTotalResultCount($totalResultCount);
    }
    /**
     * Get bulkActions value
     * @return \StructType\BulkActions|null
     */
    public function getBulkActions()
    {
        return $this->bulkActions;
    }
    /**
     * Set bulkActions value
     * @param \StructType\BulkActions $bulkActions
     * @return \StructType\BulkActionSearchResultsImpl
     */
    public function setBulkActions(\StructType\BulkActions $bulkActions = null)
    {
        $this->bulkActions = $bulkActions;
        return $this;
    }
    /**
     * Get configuredResultLimit value
     * @return int|null
     */
    public function getConfiguredResultLimit()
    {
        return $this->configuredResultLimit;
    }
    /**
     * Set configuredResultLimit value
     * @param int $configuredResultLimit
     * @return \StructType\BulkActionSearchResultsImpl
     */
    public function setConfiguredResultLimit($configuredResultLimit = null)
    {
        // validation for constraint: int
        if (!is_null($configuredResultLimit) && !is_numeric($configuredResultLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($configuredResultLimit)), __LINE__);
        }
        $this->configuredResultLimit = $configuredResultLimit;
        return $this;
    }
    /**
     * Get totalResultCount value
     * @return int|null
     */
    public function getTotalResultCount()
    {
        return $this->totalResultCount;
    }
    /**
     * Set totalResultCount value
     * @param int $totalResultCount
     * @return \StructType\BulkActionSearchResultsImpl
     */
    public function setTotalResultCount($totalResultCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalResultCount) && !is_numeric($totalResultCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalResultCount)), __LINE__);
        }
        $this->totalResultCount = $totalResultCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BulkActionSearchResultsImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
