<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bulkActionEntryImpl StructType
 * @subpackage Structs
 */
class BulkActionEntryImpl extends AbstractStructBase
{
    /**
     * The bulkActionId
     * @var string
     */
    public $bulkActionId;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The createdDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The modifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modifiedDate;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestType;
    /**
     * Constructor method for bulkActionEntryImpl
     * @uses BulkActionEntryImpl::setBulkActionId()
     * @uses BulkActionEntryImpl::setServiceType()
     * @uses BulkActionEntryImpl::setStatus()
     * @uses BulkActionEntryImpl::setCreatedDate()
     * @uses BulkActionEntryImpl::setModifiedDate()
     * @uses BulkActionEntryImpl::setRequestType()
     * @param string $bulkActionId
     * @param string $serviceType
     * @param string $status
     * @param string $createdDate
     * @param string $modifiedDate
     * @param string $requestType
     */
    public function __construct($bulkActionId = null, $serviceType = null, $status = null, $createdDate = null, $modifiedDate = null, $requestType = null)
    {
        $this
            ->setBulkActionId($bulkActionId)
            ->setServiceType($serviceType)
            ->setStatus($status)
            ->setCreatedDate($createdDate)
            ->setModifiedDate($modifiedDate)
            ->setRequestType($requestType);
    }
    /**
     * Get bulkActionId value
     * @return string|null
     */
    public function getBulkActionId()
    {
        return $this->bulkActionId;
    }
    /**
     * Set bulkActionId value
     * @param string $bulkActionId
     * @return \StructType\BulkActionEntryImpl
     */
    public function setBulkActionId($bulkActionId = null)
    {
        // validation for constraint: string
        if (!is_null($bulkActionId) && !is_string($bulkActionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bulkActionId)), __LINE__);
        }
        $this->bulkActionId = $bulkActionId;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\BulkActionEntryImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\BulkActionEntryImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\BulkActionEntryImpl
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get modifiedDate value
     * @return string|null
     */
    public function getModifiedDate()
    {
        return $this->modifiedDate;
    }
    /**
     * Set modifiedDate value
     * @param string $modifiedDate
     * @return \StructType\BulkActionEntryImpl
     */
    public function setModifiedDate($modifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifiedDate) && !is_string($modifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifiedDate)), __LINE__);
        }
        $this->modifiedDate = $modifiedDate;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @param string $requestType
     * @return \StructType\BulkActionEntryImpl
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BulkActionEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
