<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for authenticatedIwsRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:authenticatedIwsRequestImpl
 * @subpackage Structs
 */
class AuthenticatedIwsRequestImpl extends AbstractStructBase
{
    /**
     * The iwsUsername
     * @var string
     */
    public $iwsUsername;
    /**
     * The signature
     * @var string
     */
    public $signature;
    /**
     * The serviceProviderAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceProviderAccountNumber;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * The caller
     * @var string
     */
    public $caller;
    /**
     * The callerPassword
     * @var string
     */
    public $callerPassword;
    /**
     * Constructor method for authenticatedIwsRequestImpl
     * @uses AuthenticatedIwsRequestImpl::setIwsUsername()
     * @uses AuthenticatedIwsRequestImpl::setSignature()
     * @uses AuthenticatedIwsRequestImpl::setServiceProviderAccountNumber()
     * @uses AuthenticatedIwsRequestImpl::setTimestamp()
     * @uses AuthenticatedIwsRequestImpl::setCaller()
     * @uses AuthenticatedIwsRequestImpl::setCallerPassword()
     * @param string $iwsUsername
     * @param string $signature
     * @param string $serviceProviderAccountNumber
     * @param string $timestamp
     * @param string $caller
     * @param string $callerPassword
     */
    public function __construct($iwsUsername = null, $signature = null, $serviceProviderAccountNumber = null, $timestamp = null, $caller = null, $callerPassword = null)
    {
        $this
            ->setIwsUsername($iwsUsername)
            ->setSignature($signature)
            ->setServiceProviderAccountNumber($serviceProviderAccountNumber)
            ->setTimestamp($timestamp)
            ->setCaller($caller)
            ->setCallerPassword($callerPassword);
    }
    /**
     * Get iwsUsername value
     * @return string|null
     */
    public function getIwsUsername()
    {
        return $this->iwsUsername;
    }
    /**
     * Set iwsUsername value
     * @param string $iwsUsername
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public function setIwsUsername($iwsUsername = null)
    {
        // validation for constraint: string
        if (!is_null($iwsUsername) && !is_string($iwsUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iwsUsername)), __LINE__);
        }
        $this->iwsUsername = $iwsUsername;
        return $this;
    }
    /**
     * Get signature value
     * @return string|null
     */
    public function getSignature()
    {
        return $this->signature;
    }
    /**
     * Set signature value
     * @param string $signature
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public function setSignature($signature = null)
    {
        // validation for constraint: string
        if (!is_null($signature) && !is_string($signature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signature)), __LINE__);
        }
        $this->signature = $signature;
        return $this;
    }
    /**
     * Get serviceProviderAccountNumber value
     * @return string|null
     */
    public function getServiceProviderAccountNumber()
    {
        return $this->serviceProviderAccountNumber;
    }
    /**
     * Set serviceProviderAccountNumber value
     * @param string $serviceProviderAccountNumber
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public function setServiceProviderAccountNumber($serviceProviderAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderAccountNumber) && !is_string($serviceProviderAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderAccountNumber)), __LINE__);
        }
        $this->serviceProviderAccountNumber = $serviceProviderAccountNumber;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get caller value
     * @return string|null
     */
    public function getCaller()
    {
        return $this->caller;
    }
    /**
     * Set caller value
     * @param string $caller
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public function setCaller($caller = null)
    {
        // validation for constraint: string
        if (!is_null($caller) && !is_string($caller)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caller)), __LINE__);
        }
        $this->caller = $caller;
        return $this;
    }
    /**
     * Get callerPassword value
     * @return string|null
     */
    public function getCallerPassword()
    {
        return $this->callerPassword;
    }
    /**
     * Set callerPassword value
     * @param string $callerPassword
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public function setCallerPassword($callerPassword = null)
    {
        // validation for constraint: string
        if (!is_null($callerPassword) && !is_string($callerPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerPassword)), __LINE__);
        }
        $this->callerPassword = $callerPassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthenticatedIwsRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
