<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for activateScratchCardRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:activateScratchCardRequestImpl
 * @subpackage Structs
 */
class ActivateScratchCardRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The lineItemId
     * @var string
     */
    public $lineItemId;
    /**
     * The startSerial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startSerial;
    /**
     * The endSerial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endSerial;
    /**
     * The validateOnly
     * @var bool
     */
    public $validateOnly;
    /**
     * The purchaseOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $purchaseOrder;
    /**
     * Constructor method for activateScratchCardRequestImpl
     * @uses ActivateScratchCardRequestImpl::setType()
     * @uses ActivateScratchCardRequestImpl::setLineItemId()
     * @uses ActivateScratchCardRequestImpl::setStartSerial()
     * @uses ActivateScratchCardRequestImpl::setEndSerial()
     * @uses ActivateScratchCardRequestImpl::setValidateOnly()
     * @uses ActivateScratchCardRequestImpl::setPurchaseOrder()
     * @param string $type
     * @param string $lineItemId
     * @param string $startSerial
     * @param string $endSerial
     * @param bool $validateOnly
     * @param string $purchaseOrder
     */
    public function __construct($type = null, $lineItemId = null, $startSerial = null, $endSerial = null, $validateOnly = null, $purchaseOrder = null)
    {
        $this
            ->setType($type)
            ->setLineItemId($lineItemId)
            ->setStartSerial($startSerial)
            ->setEndSerial($endSerial)
            ->setValidateOnly($validateOnly)
            ->setPurchaseOrder($purchaseOrder);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ActivationTypeEnum::valueIsValid()
     * @uses \EnumType\ActivationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivationTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ActivationTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get lineItemId value
     * @return string|null
     */
    public function getLineItemId()
    {
        return $this->lineItemId;
    }
    /**
     * Set lineItemId value
     * @param string $lineItemId
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public function setLineItemId($lineItemId = null)
    {
        // validation for constraint: string
        if (!is_null($lineItemId) && !is_string($lineItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineItemId)), __LINE__);
        }
        $this->lineItemId = $lineItemId;
        return $this;
    }
    /**
     * Get startSerial value
     * @return string|null
     */
    public function getStartSerial()
    {
        return $this->startSerial;
    }
    /**
     * Set startSerial value
     * @param string $startSerial
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public function setStartSerial($startSerial = null)
    {
        // validation for constraint: string
        if (!is_null($startSerial) && !is_string($startSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startSerial)), __LINE__);
        }
        $this->startSerial = $startSerial;
        return $this;
    }
    /**
     * Get endSerial value
     * @return string|null
     */
    public function getEndSerial()
    {
        return $this->endSerial;
    }
    /**
     * Set endSerial value
     * @param string $endSerial
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public function setEndSerial($endSerial = null)
    {
        // validation for constraint: string
        if (!is_null($endSerial) && !is_string($endSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endSerial)), __LINE__);
        }
        $this->endSerial = $endSerial;
        return $this;
    }
    /**
     * Get validateOnly value
     * @return bool|null
     */
    public function getValidateOnly()
    {
        return $this->validateOnly;
    }
    /**
     * Set validateOnly value
     * @param bool $validateOnly
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public function setValidateOnly($validateOnly = null)
    {
        $this->validateOnly = $validateOnly;
        return $this;
    }
    /**
     * Get purchaseOrder value
     * @return string|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * Set purchaseOrder value
     * @param string $purchaseOrder
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public function setPurchaseOrder($purchaseOrder = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrder) && !is_string($purchaseOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchaseOrder)), __LINE__);
        }
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivateScratchCardRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
