<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for absSubscriberAccountImpl StructType
 * @subpackage Structs
 */
abstract class AbsSubscriberAccountImpl extends AbstractStructBase
{
    /**
     * The subscriberAccountNumber
     * @var string
     */
    public $subscriberAccountNumber;
    /**
     * The accountStatus
     * @var string
     */
    public $accountStatus;
    /**
     * The statusDescription
     * @var string
     */
    public $statusDescription;
    /**
     * The createDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createDate;
    /**
     * The updateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updateDate;
    /**
     * The closedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $closedDate;
    /**
     * The createdBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdBy;
    /**
     * The updatedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $updatedBy;
    /**
     * Constructor method for absSubscriberAccountImpl
     * @uses AbsSubscriberAccountImpl::setSubscriberAccountNumber()
     * @uses AbsSubscriberAccountImpl::setAccountStatus()
     * @uses AbsSubscriberAccountImpl::setStatusDescription()
     * @uses AbsSubscriberAccountImpl::setCreateDate()
     * @uses AbsSubscriberAccountImpl::setUpdateDate()
     * @uses AbsSubscriberAccountImpl::setClosedDate()
     * @uses AbsSubscriberAccountImpl::setCreatedBy()
     * @uses AbsSubscriberAccountImpl::setUpdatedBy()
     * @param string $subscriberAccountNumber
     * @param string $accountStatus
     * @param string $statusDescription
     * @param string $createDate
     * @param string $updateDate
     * @param string $closedDate
     * @param string $createdBy
     * @param string $updatedBy
     */
    public function __construct($subscriberAccountNumber = null, $accountStatus = null, $statusDescription = null, $createDate = null, $updateDate = null, $closedDate = null, $createdBy = null, $updatedBy = null)
    {
        $this
            ->setSubscriberAccountNumber($subscriberAccountNumber)
            ->setAccountStatus($accountStatus)
            ->setStatusDescription($statusDescription)
            ->setCreateDate($createDate)
            ->setUpdateDate($updateDate)
            ->setClosedDate($closedDate)
            ->setCreatedBy($createdBy)
            ->setUpdatedBy($updatedBy);
    }
    /**
     * Get subscriberAccountNumber value
     * @return string|null
     */
    public function getSubscriberAccountNumber()
    {
        return $this->subscriberAccountNumber;
    }
    /**
     * Set subscriberAccountNumber value
     * @param string $subscriberAccountNumber
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setSubscriberAccountNumber($subscriberAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberAccountNumber) && !is_string($subscriberAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberAccountNumber)), __LINE__);
        }
        $this->subscriberAccountNumber = $subscriberAccountNumber;
        return $this;
    }
    /**
     * Get accountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->accountStatus;
    }
    /**
     * Set accountStatus value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountStatus
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountStatus, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->accountStatus = $accountStatus;
        return $this;
    }
    /**
     * Get statusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->statusDescription;
    }
    /**
     * Set statusDescription value
     * @param string $statusDescription
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDescription)), __LINE__);
        }
        $this->statusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get updateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->updateDate;
    }
    /**
     * Set updateDate value
     * @param string $updateDate
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateDate)), __LINE__);
        }
        $this->updateDate = $updateDate;
        return $this;
    }
    /**
     * Get closedDate value
     * @return string|null
     */
    public function getClosedDate()
    {
        return $this->closedDate;
    }
    /**
     * Set closedDate value
     * @param string $closedDate
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setClosedDate($closedDate = null)
    {
        // validation for constraint: string
        if (!is_null($closedDate) && !is_string($closedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closedDate)), __LINE__);
        }
        $this->closedDate = $closedDate;
        return $this;
    }
    /**
     * Get createdBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->createdBy;
    }
    /**
     * Set createdBy value
     * @param string $createdBy
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->createdBy = $createdBy;
        return $this;
    }
    /**
     * Get updatedBy value
     * @return string|null
     */
    public function getUpdatedBy()
    {
        return $this->updatedBy;
    }
    /**
     * Set updatedBy value
     * @param string $updatedBy
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public function setUpdatedBy($updatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($updatedBy) && !is_string($updatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updatedBy)), __LINE__);
        }
        $this->updatedBy = $updatedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbsSubscriberAccountImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
