<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for absServicePlanImpl StructType
 * @subpackage Structs
 */
class AbsServicePlanImpl extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The servicePlanType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $servicePlanType;
    /**
     * The obsolete
     * @var bool
     */
    public $obsolete;
    /**
     * The demoTrial
     * @var string
     */
    public $demoTrial;
    /**
     * The prepaidPlan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $prepaidPlan;
    /**
     * Constructor method for absServicePlanImpl
     * @uses AbsServicePlanImpl::setId()
     * @uses AbsServicePlanImpl::setName()
     * @uses AbsServicePlanImpl::setServicePlanType()
     * @uses AbsServicePlanImpl::setObsolete()
     * @uses AbsServicePlanImpl::setDemoTrial()
     * @uses AbsServicePlanImpl::setPrepaidPlan()
     * @param string $id
     * @param string $name
     * @param string $servicePlanType
     * @param bool $obsolete
     * @param string $demoTrial
     * @param string $prepaidPlan
     */
    public function __construct($id = null, $name = null, $servicePlanType = null, $obsolete = null, $demoTrial = null, $prepaidPlan = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setServicePlanType($servicePlanType)
            ->setObsolete($obsolete)
            ->setDemoTrial($demoTrial)
            ->setPrepaidPlan($prepaidPlan);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AbsServicePlanImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AbsServicePlanImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get servicePlanType value
     * @return string|null
     */
    public function getServicePlanType()
    {
        return $this->servicePlanType;
    }
    /**
     * Set servicePlanType value
     * @param string $servicePlanType
     * @return \StructType\AbsServicePlanImpl
     */
    public function setServicePlanType($servicePlanType = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlanType) && !is_string($servicePlanType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlanType)), __LINE__);
        }
        $this->servicePlanType = $servicePlanType;
        return $this;
    }
    /**
     * Get obsolete value
     * @return bool|null
     */
    public function getObsolete()
    {
        return $this->obsolete;
    }
    /**
     * Set obsolete value
     * @param bool $obsolete
     * @return \StructType\AbsServicePlanImpl
     */
    public function setObsolete($obsolete = null)
    {
        $this->obsolete = $obsolete;
        return $this;
    }
    /**
     * Get demoTrial value
     * @return string|null
     */
    public function getDemoTrial()
    {
        return $this->demoTrial;
    }
    /**
     * Set demoTrial value
     * @uses \EnumType\DatTypeEnum::valueIsValid()
     * @uses \EnumType\DatTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $demoTrial
     * @return \StructType\AbsServicePlanImpl
     */
    public function setDemoTrial($demoTrial = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatTypeEnum::valueIsValid($demoTrial)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $demoTrial, implode(', ', \EnumType\DatTypeEnum::getValidValues())), __LINE__);
        }
        $this->demoTrial = $demoTrial;
        return $this;
    }
    /**
     * Get prepaidPlan value
     * @return string|null
     */
    public function getPrepaidPlan()
    {
        return $this->prepaidPlan;
    }
    /**
     * Set prepaidPlan value
     * @param string $prepaidPlan
     * @return \StructType\AbsServicePlanImpl
     */
    public function setPrepaidPlan($prepaidPlan = null)
    {
        // validation for constraint: string
        if (!is_null($prepaidPlan) && !is_string($prepaidPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prepaidPlan)), __LINE__);
        }
        $this->prepaidPlan = $prepaidPlan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbsServicePlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
