<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updatePTTSubOrgStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePTTSubOrgStatusRequestImpl $request
     * @return \StructType\UpdatePTTSubOrgStatusResponseImpl|bool
     */
    public function updatePTTSubOrgStatus(\StructType\UpdatePTTSubOrgStatusRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->updatePTTSubOrgStatus($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateEmailNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEmailNotificationRequestImpl $request
     * @return \StructType\IwsResponseImpl|bool
     */
    public function updateEmailNotification(\StructType\UpdateEmailNotificationRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->updateEmailNotification($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateUserProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateUserProfileRequestImpl $request
     * @return \StructType\UpdateUserProfileResponseImpl|bool
     */
    public function updateUserProfile(\StructType\UpdateUserProfileRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->updateUserProfile($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateSubscriberOrganization
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSubscriberOrgRequestImpl $request
     * @return \StructType\SubscriberOrgsResponseImpl|bool
     */
    public function updateSubscriberOrganization(\StructType\UpdateSubscriberOrgRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->updateSubscriberOrganization($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IwsResponseImpl|\StructType\SubscriberOrgsResponseImpl|\StructType\UpdatePTTSubOrgStatusResponseImpl|\StructType\UpdateUserProfileResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
