<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sbd ServiceType
 * @subpackage Services
 */
class Sbd extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named sbdMOQueueReport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SbdMOQueueReportRequestImpl $request
     * @return \StructType\SbdMOQueueReportResponseImpl|bool
     */
    public function sbdMOQueueReport(\StructType\SbdMOQueueReportRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->sbdMOQueueReport($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sbdDeletePendingDownloads
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SbdDeletePendingDownloadsRequestImpl $request
     * @return \StructType\SbdDeletePendingDownloadsResponseImpl|bool
     */
    public function sbdDeletePendingDownloads(\StructType\SbdDeletePendingDownloadsRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->sbdDeletePendingDownloads($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sbdImeiSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SbdImeiSearchRequestImpl $request
     * @return \StructType\SbdImeiSearchResponseImpl|bool
     */
    public function sbdImeiSearch(\StructType\SbdImeiSearchRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->sbdImeiSearch($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sbdDestinationSearchReplace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeliveryDestinationSearchAndReplaceRequestImpl $request
     * @return \StructType\DeliveryDestinationSearchAndReplaceResponseImpl|bool
     */
    public function sbdDestinationSearchReplace(\StructType\DeliveryDestinationSearchAndReplaceRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->sbdDestinationSearchReplace($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named sbdMOQueuePurge
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SbdMOQueuePurgeRequestImpl $request
     * @return \StructType\SbdMOQueuePurgeResponseImpl|bool
     */
    public function sbdMOQueuePurge(\StructType\SbdMOQueuePurgeRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->sbdMOQueuePurge($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeliveryDestinationSearchAndReplaceResponseImpl|\StructType\SbdDeletePendingDownloadsResponseImpl|\StructType\SbdImeiSearchResponseImpl|\StructType\SbdMOQueuePurgeResponseImpl|\StructType\SbdMOQueueReportResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
