<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Device ServiceType
 * @subpackage Services
 */
class Device extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deviceTransferOwner
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeviceTransferOwnerRequestImpl $request
     * @return \StructType\DeviceTransferOwnerResponseImpl|bool
     */
    public function deviceTransferOwner(\StructType\DeviceTransferOwnerRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->deviceTransferOwner($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeviceTransferOwnerResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
