<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Associate ServiceType
 * @subpackage Services
 */
class Associate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named associateSimToImeiDevice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AssociateSimToImeiRequestImpl $request
     * @return \StructType\IwsResponseImpl|bool
     */
    public function associateSimToImeiDevice(\StructType\AssociateSimToImeiRequestImpl $request)
    {
        try {
            $this->setResult(self::getSoapClient()->associateSimToImeiDevice($request));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IwsResponseImpl
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
