<?php

namespace EnumType;

/**
 * This class stands for voucherInventoryTypeEnum EnumType
 * @subpackage Enumerations
 */
class VoucherInventoryTypeEnum
{
    /**
     * Constant for value 'SCRATCHCARD'
     * @return string 'SCRATCHCARD'
     */
    const VALUE_SCRATCHCARD = 'SCRATCHCARD';
    /**
     * Constant for value 'EVOUCHER'
     * @return string 'EVOUCHER'
     */
    const VALUE_EVOUCHER = 'EVOUCHER';
    /**
     * Constant for value 'EVOUCHER_RECHARGE'
     * @return string 'EVOUCHER_RECHARGE'
     */
    const VALUE_EVOUCHER_RECHARGE = 'EVOUCHER_RECHARGE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SCRATCHCARD
     * @uses self::VALUE_EVOUCHER
     * @uses self::VALUE_EVOUCHER_RECHARGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCRATCHCARD,
            self::VALUE_EVOUCHER,
            self::VALUE_EVOUCHER_RECHARGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
