<?php

namespace EnumType;

/**
 * This class stands for subscriberAccountSearchTypeEnum EnumType
 * @subpackage Enumerations
 */
class SubscriberAccountSearchTypeEnum
{
    /**
     * Constant for value 'ACCOUNT_NUMBER'
     * @return string 'ACCOUNT_NUMBER'
     */
    const VALUE_ACCOUNT_NUMBER = 'ACCOUNT_NUMBER';
    /**
     * Constant for value 'MSISDN'
     * @return string 'MSISDN'
     */
    const VALUE_MSISDN = 'MSISDN';
    /**
     * Constant for value 'MSISDNB'
     * @return string 'MSISDNB'
     */
    const VALUE_MSISDNB = 'MSISDNB';
    /**
     * Constant for value 'MSISDNC'
     * @return string 'MSISDNC'
     */
    const VALUE_MSISDNC = 'MSISDNC';
    /**
     * Constant for value 'SIM_SERIAL_NUMBER'
     * @return string 'SIM_SERIAL_NUMBER'
     */
    const VALUE_SIM_SERIAL_NUMBER = 'SIM_SERIAL_NUMBER';
    /**
     * Constant for value 'IMSI'
     * @return string 'IMSI'
     */
    const VALUE_IMSI = 'IMSI';
    /**
     * Constant for value 'CAPCODE'
     * @return string 'CAPCODE'
     */
    const VALUE_CAPCODE = 'CAPCODE';
    /**
     * Constant for value 'IMEI'
     * @return string 'IMEI'
     */
    const VALUE_IMEI = 'IMEI';
    /**
     * Constant for value 'LOCAL'
     * @return string 'LOCAL'
     */
    const VALUE_LOCAL = 'LOCAL';
    /**
     * Constant for value 'IP_ADDRESS'
     * @return string 'IP_ADDRESS'
     */
    const VALUE_IP_ADDRESS = 'IP_ADDRESS';
    /**
     * Constant for value 'PROVIDER_REFERENCE'
     * @return string 'PROVIDER_REFERENCE'
     */
    const VALUE_PROVIDER_REFERENCE = 'PROVIDER_REFERENCE';
    /**
     * Constant for value 'VESSEL_NAME'
     * @return string 'VESSEL_NAME'
     */
    const VALUE_VESSEL_NAME = 'VESSEL_NAME';
    /**
     * Constant for value 'MMSI'
     * @return string 'MMSI'
     */
    const VALUE_MMSI = 'MMSI';
    /**
     * Constant for value 'ISDNA'
     * @return string 'ISDNA'
     */
    const VALUE_ISDNA = 'ISDNA';
    /**
     * Constant for value 'BURST_SERVICE'
     * @return string 'BURST_SERVICE'
     */
    const VALUE_BURST_SERVICE = 'BURST_SERVICE';
    /**
     * Constant for value 'DELIVERY_DEST'
     * @return string 'DELIVERY_DEST'
     */
    const VALUE_DELIVERY_DEST = 'DELIVERY_DEST';
    /**
     * Constant for value 'MT_FILTER'
     * @return string 'MT_FILTER'
     */
    const VALUE_MT_FILTER = 'MT_FILTER';
    /**
     * Constant for value 'MODEL'
     * @return string 'MODEL'
     */
    const VALUE_MODEL = 'MODEL';
    /**
     * Constant for value 'ATS_ICAO'
     * @return string 'ATS_ICAO'
     */
    const VALUE_ATS_ICAO = 'ATS_ICAO';
    /**
     * Constant for value 'ATS_REG_TAIL_NUMBER'
     * @return string 'ATS_REG_TAIL_NUMBER'
     */
    const VALUE_ATS_REG_TAIL_NUMBER = 'ATS_REG_TAIL_NUMBER';
    /**
     * Constant for value 'SHARED_GROUP'
     * @return string 'SHARED_GROUP'
     */
    const VALUE_SHARED_GROUP = 'SHARED_GROUP';
    /**
     * Constant for value 'SMART'
     * @return string 'SMART'
     */
    const VALUE_SMART = 'SMART';
    /**
     * Constant for value 'PTT_TG'
     * @return string 'PTT_TG'
     */
    const VALUE_PTT_TG = 'PTT_TG';
    /**
     * Constant for value 'VERTICAL'
     * @return string 'VERTICAL'
     */
    const VALUE_VERTICAL = 'VERTICAL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCOUNT_NUMBER
     * @uses self::VALUE_MSISDN
     * @uses self::VALUE_MSISDNB
     * @uses self::VALUE_MSISDNC
     * @uses self::VALUE_SIM_SERIAL_NUMBER
     * @uses self::VALUE_IMSI
     * @uses self::VALUE_CAPCODE
     * @uses self::VALUE_IMEI
     * @uses self::VALUE_LOCAL
     * @uses self::VALUE_IP_ADDRESS
     * @uses self::VALUE_PROVIDER_REFERENCE
     * @uses self::VALUE_VESSEL_NAME
     * @uses self::VALUE_MMSI
     * @uses self::VALUE_ISDNA
     * @uses self::VALUE_BURST_SERVICE
     * @uses self::VALUE_DELIVERY_DEST
     * @uses self::VALUE_MT_FILTER
     * @uses self::VALUE_MODEL
     * @uses self::VALUE_ATS_ICAO
     * @uses self::VALUE_ATS_REG_TAIL_NUMBER
     * @uses self::VALUE_SHARED_GROUP
     * @uses self::VALUE_SMART
     * @uses self::VALUE_PTT_TG
     * @uses self::VALUE_VERTICAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCOUNT_NUMBER,
            self::VALUE_MSISDN,
            self::VALUE_MSISDNB,
            self::VALUE_MSISDNC,
            self::VALUE_SIM_SERIAL_NUMBER,
            self::VALUE_IMSI,
            self::VALUE_CAPCODE,
            self::VALUE_IMEI,
            self::VALUE_LOCAL,
            self::VALUE_IP_ADDRESS,
            self::VALUE_PROVIDER_REFERENCE,
            self::VALUE_VESSEL_NAME,
            self::VALUE_MMSI,
            self::VALUE_ISDNA,
            self::VALUE_BURST_SERVICE,
            self::VALUE_DELIVERY_DEST,
            self::VALUE_MT_FILTER,
            self::VALUE_MODEL,
            self::VALUE_ATS_ICAO,
            self::VALUE_ATS_REG_TAIL_NUMBER,
            self::VALUE_SHARED_GROUP,
            self::VALUE_SMART,
            self::VALUE_PTT_TG,
            self::VALUE_VERTICAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
