<?php

namespace EnumType;

/**
 * This class stands for statusChangeTypeEnum EnumType
 * @subpackage Enumerations
 */
class StatusChangeTypeEnum
{
    /**
     * Constant for value 'SUBSCRIBER_ACCOUNT_NUMBER'
     * @return string 'SUBSCRIBER_ACCOUNT_NUMBER'
     */
    const VALUE_SUBSCRIBER_ACCOUNT_NUMBER = 'SUBSCRIBER_ACCOUNT_NUMBER';
    /**
     * Constant for value 'MSISDN'
     * @return string 'MSISDN'
     */
    const VALUE_MSISDN = 'MSISDN';
    /**
     * Constant for value 'IMEI'
     * @return string 'IMEI'
     */
    const VALUE_IMEI = 'IMEI';
    /**
     * Constant for value 'CAPCODE'
     * @return string 'CAPCODE'
     */
    const VALUE_CAPCODE = 'CAPCODE';
    /**
     * Constant for value 'ISDNA'
     * @return string 'ISDNA'
     */
    const VALUE_ISDNA = 'ISDNA';
    /**
     * Constant for value 'SIM'
     * @return string 'SIM'
     */
    const VALUE_SIM = 'SIM';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUBSCRIBER_ACCOUNT_NUMBER
     * @uses self::VALUE_MSISDN
     * @uses self::VALUE_IMEI
     * @uses self::VALUE_CAPCODE
     * @uses self::VALUE_ISDNA
     * @uses self::VALUE_SIM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUBSCRIBER_ACCOUNT_NUMBER,
            self::VALUE_MSISDN,
            self::VALUE_IMEI,
            self::VALUE_CAPCODE,
            self::VALUE_ISDNA,
            self::VALUE_SIM,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
