<?php

namespace EnumType;

/**
 * This class stands for simLockStatusEnum EnumType
 * @subpackage Enumerations
 */
class SimLockStatusEnum
{
    /**
     * Constant for value 'UNLOCKED'
     * @return string 'UNLOCKED'
     */
    const VALUE_UNLOCKED = 'UNLOCKED';
    /**
     * Constant for value 'LOCKED'
     * @return string 'LOCKED'
     */
    const VALUE_LOCKED = 'LOCKED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNLOCKED
     * @uses self::VALUE_LOCKED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNLOCKED,
            self::VALUE_LOCKED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
