<?php

namespace EnumType;

/**
 * This class stands for secondarySvcTypeEnum EnumType
 * @subpackage Enumerations
 */
class SecondarySvcTypeEnum
{
    /**
     * Constant for value 'CERTUS_VOICE'
     * @return string 'CERTUS_VOICE'
     */
    const VALUE_CERTUS_VOICE = 'CERTUS_VOICE';
    /**
     * Constant for value 'CERTUS_STREAMING'
     * @return string 'CERTUS_STREAMING'
     */
    const VALUE_CERTUS_STREAMING = 'CERTUS_STREAMING';
    /**
     * Constant for value 'SHORT_BURST_DATA'
     * @return string 'SHORT_BURST_DATA'
     */
    const VALUE_SHORT_BURST_DATA = 'SHORT_BURST_DATA';
    /**
     * Constant for value 'PTT_DEVICE'
     * @return string 'PTT_DEVICE'
     */
    const VALUE_PTT_DEVICE = 'PTT_DEVICE';
    /**
     * Constant for value 'BURST_DEVICE'
     * @return string 'BURST_DEVICE'
     */
    const VALUE_BURST_DEVICE = 'BURST_DEVICE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERTUS_VOICE
     * @uses self::VALUE_CERTUS_STREAMING
     * @uses self::VALUE_SHORT_BURST_DATA
     * @uses self::VALUE_PTT_DEVICE
     * @uses self::VALUE_BURST_DEVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTUS_VOICE,
            self::VALUE_CERTUS_STREAMING,
            self::VALUE_SHORT_BURST_DATA,
            self::VALUE_PTT_DEVICE,
            self::VALUE_BURST_DEVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
