<?php

namespace EnumType;

/**
 * This class stands for searchCondEnum EnumType
 * @subpackage Enumerations
 */
class SearchCondEnum
{
    /**
     * Constant for value 'EQUALS'
     * @return string 'EQUALS'
     */
    const VALUE_EQUALS = 'EQUALS';
    /**
     * Constant for value 'NOT_EQUAL'
     * @return string 'NOT_EQUAL'
     */
    const VALUE_NOT_EQUAL = 'NOT_EQUAL';
    /**
     * Constant for value 'LIKE'
     * @return string 'LIKE'
     */
    const VALUE_LIKE = 'LIKE';
    /**
     * Constant for value 'NOT_LIKE'
     * @return string 'NOT_LIKE'
     */
    const VALUE_NOT_LIKE = 'NOT_LIKE';
    /**
     * Constant for value 'CONTAINS'
     * @return string 'CONTAINS'
     */
    const VALUE_CONTAINS = 'CONTAINS';
    /**
     * Constant for value 'DOES_NOT_CONTAIN'
     * @return string 'DOES_NOT_CONTAIN'
     */
    const VALUE_DOES_NOT_CONTAIN = 'DOES_NOT_CONTAIN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EQUALS
     * @uses self::VALUE_NOT_EQUAL
     * @uses self::VALUE_LIKE
     * @uses self::VALUE_NOT_LIKE
     * @uses self::VALUE_CONTAINS
     * @uses self::VALUE_DOES_NOT_CONTAIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EQUALS,
            self::VALUE_NOT_EQUAL,
            self::VALUE_LIKE,
            self::VALUE_NOT_LIKE,
            self::VALUE_CONTAINS,
            self::VALUE_DOES_NOT_CONTAIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
