<?php

namespace EnumType;

/**
 * This class stands for sbdSendMessageStatusTypeEnum EnumType
 * @subpackage Enumerations
 */
class SbdSendMessageStatusTypeEnum
{
    /**
     * Constant for value 'SUCCEEDED'
     * @return string 'SUCCEEDED'
     */
    const VALUE_SUCCEEDED = 'SUCCEEDED';
    /**
     * Constant for value 'FAILED'
     * @return string 'FAILED'
     */
    const VALUE_FAILED = 'FAILED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SUCCEEDED
     * @uses self::VALUE_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SUCCEEDED,
            self::VALUE_FAILED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
