<?php

namespace EnumType;

/**
 * This class stands for sbdDestSearchAndReplaceResultTypeEnum EnumType
 * @subpackage Enumerations
 */
class SbdDestSearchAndReplaceResultTypeEnum
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'ONLY_DESTINATION'
     * @return string 'ONLY_DESTINATION'
     */
    const VALUE_ONLY_DESTINATION = 'ONLY_DESTINATION';
    /**
     * Constant for value 'DUPLICATE'
     * @return string 'DUPLICATE'
     */
    const VALUE_DUPLICATE = 'DUPLICATE';
    /**
     * Constant for value 'INVALID_FOR_METHOD'
     * @return string 'INVALID_FOR_METHOD'
     */
    const VALUE_INVALID_FOR_METHOD = 'INVALID_FOR_METHOD';
    /**
     * Constant for value 'FAILED'
     * @return string 'FAILED'
     */
    const VALUE_FAILED = 'FAILED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_ONLY_DESTINATION
     * @uses self::VALUE_DUPLICATE
     * @uses self::VALUE_INVALID_FOR_METHOD
     * @uses self::VALUE_FAILED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_ONLY_DESTINATION,
            self::VALUE_DUPLICATE,
            self::VALUE_INVALID_FOR_METHOD,
            self::VALUE_FAILED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
