<?php

namespace EnumType;

/**
 * This class stands for sbdActivityOrderByTypeEnum EnumType
 * @subpackage Enumerations
 */
class SbdActivityOrderByTypeEnum
{
    /**
     * Constant for value 'UPLOAD_TIMESTAMP'
     * @return string 'UPLOAD_TIMESTAMP'
     */
    const VALUE_UPLOAD_TIMESTAMP = 'UPLOAD_TIMESTAMP';
    /**
     * Constant for value 'UPLOAD_MESSAGE_SIZE'
     * @return string 'UPLOAD_MESSAGE_SIZE'
     */
    const VALUE_UPLOAD_MESSAGE_SIZE = 'UPLOAD_MESSAGE_SIZE';
    /**
     * Constant for value 'LATITUDE'
     * @return string 'LATITUDE'
     */
    const VALUE_LATITUDE = 'LATITUDE';
    /**
     * Constant for value 'LONGITUDE'
     * @return string 'LONGITUDE'
     */
    const VALUE_LONGITUDE = 'LONGITUDE';
    /**
     * Constant for value 'CEP_RADIUS'
     * @return string 'CEP_RADIUS'
     */
    const VALUE_CEP_RADIUS = 'CEP_RADIUS';
    /**
     * Constant for value 'UPLOAD_CALL_NUMBER'
     * @return string 'UPLOAD_CALL_NUMBER'
     */
    const VALUE_UPLOAD_CALL_NUMBER = 'UPLOAD_CALL_NUMBER';
    /**
     * Constant for value 'MOMSN'
     * @return string 'MOMSN'
     */
    const VALUE_MOMSN = 'MOMSN';
    /**
     * Constant for value 'CALL_STATUS'
     * @return string 'CALL_STATUS'
     */
    const VALUE_CALL_STATUS = 'CALL_STATUS';
    /**
     * Constant for value 'DELIVERY_METHOD'
     * @return string 'DELIVERY_METHOD'
     */
    const VALUE_DELIVERY_METHOD = 'DELIVERY_METHOD';
    /**
     * Constant for value 'DELIVERY_STATUS'
     * @return string 'DELIVERY_STATUS'
     */
    const VALUE_DELIVERY_STATUS = 'DELIVERY_STATUS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UPLOAD_TIMESTAMP
     * @uses self::VALUE_UPLOAD_MESSAGE_SIZE
     * @uses self::VALUE_LATITUDE
     * @uses self::VALUE_LONGITUDE
     * @uses self::VALUE_CEP_RADIUS
     * @uses self::VALUE_UPLOAD_CALL_NUMBER
     * @uses self::VALUE_MOMSN
     * @uses self::VALUE_CALL_STATUS
     * @uses self::VALUE_DELIVERY_METHOD
     * @uses self::VALUE_DELIVERY_STATUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UPLOAD_TIMESTAMP,
            self::VALUE_UPLOAD_MESSAGE_SIZE,
            self::VALUE_LATITUDE,
            self::VALUE_LONGITUDE,
            self::VALUE_CEP_RADIUS,
            self::VALUE_UPLOAD_CALL_NUMBER,
            self::VALUE_MOMSN,
            self::VALUE_CALL_STATUS,
            self::VALUE_DELIVERY_METHOD,
            self::VALUE_DELIVERY_STATUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
