<?php

namespace EnumType;

/**
 * This class stands for messageContentTypeEnum EnumType
 * @subpackage Enumerations
 */
class MessageContentTypeEnum
{
    /**
     * Constant for value 'BASE_64'
     * @return string 'BASE_64'
     */
    const VALUE_BASE_64 = 'BASE_64';
    /**
     * Constant for value 'ASCII_TEXT'
     * @return string 'ASCII_TEXT'
     */
    const VALUE_ASCII_TEXT = 'ASCII_TEXT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASE_64
     * @uses self::VALUE_ASCII_TEXT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASE_64,
            self::VALUE_ASCII_TEXT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
