<?php

namespace EnumType;

/**
 * This class stands for imeiTypeEnum EnumType
 * @subpackage Enumerations
 */
class ImeiTypeEnum
{
    /**
     * Constant for value 'REGULAR_IMEI'
     * @return string 'REGULAR_IMEI'
     */
    const VALUE_REGULAR_IMEI = 'REGULAR_IMEI';
    /**
     * Constant for value 'LBS_IMEI'
     * @return string 'LBS_IMEI'
     */
    const VALUE_LBS_IMEI = 'LBS_IMEI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REGULAR_IMEI
     * @uses self::VALUE_LBS_IMEI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REGULAR_IMEI,
            self::VALUE_LBS_IMEI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
