<?php

namespace EnumType;

/**
 * This class stands for errorCodeEnum EnumType
 * @subpackage Enumerations
 */
class ErrorCodeEnum
{
    /**
     * Constant for value 'CONFIG'
     * @return string 'CONFIG'
     */
    const VALUE_CONFIG = 'CONFIG';
    /**
     * Constant for value 'AUTH'
     * @return string 'AUTH'
     */
    const VALUE_AUTH = 'AUTH';
    /**
     * Constant for value 'FIELD'
     * @return string 'FIELD'
     */
    const VALUE_FIELD = 'FIELD';
    /**
     * Constant for value 'SYS'
     * @return string 'SYS'
     */
    const VALUE_SYS = 'SYS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONFIG
     * @uses self::VALUE_AUTH
     * @uses self::VALUE_FIELD
     * @uses self::VALUE_SYS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONFIG,
            self::VALUE_AUTH,
            self::VALUE_FIELD,
            self::VALUE_SYS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
