<?php

namespace EnumType;

/**
 * This class stands for dateRangeTypeEnum EnumType
 * @subpackage Enumerations
 */
class DateRangeTypeEnum
{
    /**
     * Constant for value 'PREVMONTH'
     * @return string 'PREVMONTH'
     */
    const VALUE_PREVMONTH = 'PREVMONTH';
    /**
     * Constant for value 'MTD'
     * @return string 'MTD'
     */
    const VALUE_MTD = 'MTD';
    /**
     * Constant for value 'YTD'
     * @return string 'YTD'
     */
    const VALUE_YTD = 'YTD';
    /**
     * Constant for value 'TODAY'
     * @return string 'TODAY'
     */
    const VALUE_TODAY = 'TODAY';
    /**
     * Constant for value 'YESTERDAY'
     * @return string 'YESTERDAY'
     */
    const VALUE_YESTERDAY = 'YESTERDAY';
    /**
     * Constant for value 'WTD'
     * @return string 'WTD'
     */
    const VALUE_WTD = 'WTD';
    /**
     * Constant for value 'PREVWEEK'
     * @return string 'PREVWEEK'
     */
    const VALUE_PREVWEEK = 'PREVWEEK';
    /**
     * Constant for value 'CUSTOM'
     * @return string 'CUSTOM'
     */
    const VALUE_CUSTOM = 'CUSTOM';
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PREVMONTH
     * @uses self::VALUE_MTD
     * @uses self::VALUE_YTD
     * @uses self::VALUE_TODAY
     * @uses self::VALUE_YESTERDAY
     * @uses self::VALUE_WTD
     * @uses self::VALUE_PREVWEEK
     * @uses self::VALUE_CUSTOM
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PREVMONTH,
            self::VALUE_MTD,
            self::VALUE_YTD,
            self::VALUE_TODAY,
            self::VALUE_YESTERDAY,
            self::VALUE_WTD,
            self::VALUE_PREVWEEK,
            self::VALUE_CUSTOM,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
