<?php

namespace EnumType;

/**
 * This class stands for callServiceCodeEnum EnumType
 * @subpackage Enumerations
 */
class CallServiceCodeEnum
{
    /**
     * Constant for value 'VOICE'
     * @return string 'VOICE'
     */
    const VALUE_VOICE = 'VOICE';
    /**
     * Constant for value 'DATA'
     * @return string 'DATA'
     */
    const VALUE_DATA = 'DATA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VOICE
     * @uses self::VALUE_DATA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOICE,
            self::VALUE_DATA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
