<?php

namespace EnumType;

/**
 * This class stands for atsChannelTypeEnum EnumType
 * @subpackage Enumerations
 */
class AtsChannelTypeEnum
{
    /**
     * Constant for value 'PRIMARY'
     * @return string 'PRIMARY'
     */
    const VALUE_PRIMARY = 'PRIMARY';
    /**
     * Constant for value 'SECONDARY'
     * @return string 'SECONDARY'
     */
    const VALUE_SECONDARY = 'SECONDARY';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRIMARY
     * @uses self::VALUE_SECONDARY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRIMARY,
            self::VALUE_SECONDARY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
