<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for voucherLineItemImpl StructType
 * @subpackage Structs
 */
class VoucherLineItemImpl extends AbstractStructBase
{
    /**
     * The lineItemId
     * @var string
     */
    public $lineItemId;
    /**
     * The bulkPart
     * @var \StructType\BulkBundleInfoImpl
     */
    public $bulkPart;
    /**
     * The part
     * @var \StructType\BundleInfoImpl
     */
    public $part;
    /**
     * The quantity
     * @var int
     */
    public $quantity;
    /**
     * The requestedStartSerial
     * @var string
     */
    public $requestedStartSerial;
    /**
     * The assignedSerialRanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AssignedSerialRanges
     */
    public $assignedSerialRanges;
    /**
     * The purchaseEventIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $purchaseEventIds;
    /**
     * Constructor method for voucherLineItemImpl
     * @uses VoucherLineItemImpl::setLineItemId()
     * @uses VoucherLineItemImpl::setBulkPart()
     * @uses VoucherLineItemImpl::setPart()
     * @uses VoucherLineItemImpl::setQuantity()
     * @uses VoucherLineItemImpl::setRequestedStartSerial()
     * @uses VoucherLineItemImpl::setAssignedSerialRanges()
     * @uses VoucherLineItemImpl::setPurchaseEventIds()
     * @param string $lineItemId
     * @param \StructType\BulkBundleInfoImpl $bulkPart
     * @param \StructType\BundleInfoImpl $part
     * @param int $quantity
     * @param string $requestedStartSerial
     * @param \StructType\AssignedSerialRanges $assignedSerialRanges
     * @param string[] $purchaseEventIds
     */
    public function __construct($lineItemId = null, \StructType\BulkBundleInfoImpl $bulkPart = null, \StructType\BundleInfoImpl $part = null, $quantity = null, $requestedStartSerial = null, \StructType\AssignedSerialRanges $assignedSerialRanges = null, array $purchaseEventIds = array())
    {
        $this
            ->setLineItemId($lineItemId)
            ->setBulkPart($bulkPart)
            ->setPart($part)
            ->setQuantity($quantity)
            ->setRequestedStartSerial($requestedStartSerial)
            ->setAssignedSerialRanges($assignedSerialRanges)
            ->setPurchaseEventIds($purchaseEventIds);
    }
    /**
     * Get lineItemId value
     * @return string|null
     */
    public function getLineItemId()
    {
        return $this->lineItemId;
    }
    /**
     * Set lineItemId value
     * @param string $lineItemId
     * @return \StructType\VoucherLineItemImpl
     */
    public function setLineItemId($lineItemId = null)
    {
        // validation for constraint: string
        if (!is_null($lineItemId) && !is_string($lineItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineItemId)), __LINE__);
        }
        $this->lineItemId = $lineItemId;
        return $this;
    }
    /**
     * Get bulkPart value
     * @return \StructType\BulkBundleInfoImpl|null
     */
    public function getBulkPart()
    {
        return $this->bulkPart;
    }
    /**
     * Set bulkPart value
     * @param \StructType\BulkBundleInfoImpl $bulkPart
     * @return \StructType\VoucherLineItemImpl
     */
    public function setBulkPart(\StructType\BulkBundleInfoImpl $bulkPart = null)
    {
        $this->bulkPart = $bulkPart;
        return $this;
    }
    /**
     * Get part value
     * @return \StructType\BundleInfoImpl|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param \StructType\BundleInfoImpl $part
     * @return \StructType\VoucherLineItemImpl
     */
    public function setPart(\StructType\BundleInfoImpl $part = null)
    {
        $this->part = $part;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\VoucherLineItemImpl
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get requestedStartSerial value
     * @return string|null
     */
    public function getRequestedStartSerial()
    {
        return $this->requestedStartSerial;
    }
    /**
     * Set requestedStartSerial value
     * @param string $requestedStartSerial
     * @return \StructType\VoucherLineItemImpl
     */
    public function setRequestedStartSerial($requestedStartSerial = null)
    {
        // validation for constraint: string
        if (!is_null($requestedStartSerial) && !is_string($requestedStartSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestedStartSerial)), __LINE__);
        }
        $this->requestedStartSerial = $requestedStartSerial;
        return $this;
    }
    /**
     * Get assignedSerialRanges value
     * @return \StructType\AssignedSerialRanges|null
     */
    public function getAssignedSerialRanges()
    {
        return $this->assignedSerialRanges;
    }
    /**
     * Set assignedSerialRanges value
     * @param \StructType\AssignedSerialRanges $assignedSerialRanges
     * @return \StructType\VoucherLineItemImpl
     */
    public function setAssignedSerialRanges(\StructType\AssignedSerialRanges $assignedSerialRanges = null)
    {
        $this->assignedSerialRanges = $assignedSerialRanges;
        return $this;
    }
    /**
     * Get purchaseEventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPurchaseEventIds()
    {
        return isset($this->purchaseEventIds) ? $this->purchaseEventIds : null;
    }
    /**
     * Set purchaseEventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $purchaseEventIds
     * @return \StructType\VoucherLineItemImpl
     */
    public function setPurchaseEventIds(array $purchaseEventIds = array())
    {
        foreach ($purchaseEventIds as $voucherLineItemImplPurchaseEventIdsItem) {
            // validation for constraint: itemType
            if (!is_string($voucherLineItemImplPurchaseEventIdsItem)) {
                throw new \InvalidArgumentException(sprintf('The purchaseEventIds property can only contain items of string, "%s" given', is_object($voucherLineItemImplPurchaseEventIdsItem) ? get_class($voucherLineItemImplPurchaseEventIdsItem) : gettype($voucherLineItemImplPurchaseEventIdsItem)), __LINE__);
            }
        }
        if (is_null($purchaseEventIds) || (is_array($purchaseEventIds) && empty($purchaseEventIds))) {
            unset($this->purchaseEventIds);
        } else {
            $this->purchaseEventIds = $purchaseEventIds;
        }
        return $this;
    }
    /**
     * Add item to purchaseEventIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VoucherLineItemImpl
     */
    public function addToPurchaseEventIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The purchaseEventIds property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->purchaseEventIds[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VoucherLineItemImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
