<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userAccessInfoImpl StructType
 * @subpackage Structs
 */
class UserAccessInfoImpl extends AbstractStructBase
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $role;
    /**
     * The spAcct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $spAcct;
    /**
     * The serviceProviderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceProviderName;
    /**
     * The userPrefs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userPrefs;
    /**
     * Constructor method for userAccessInfoImpl
     * @uses UserAccessInfoImpl::setRole()
     * @uses UserAccessInfoImpl::setSpAcct()
     * @uses UserAccessInfoImpl::setServiceProviderName()
     * @uses UserAccessInfoImpl::setUserPrefs()
     * @param string $role
     * @param string $spAcct
     * @param string $serviceProviderName
     * @param string $userPrefs
     */
    public function __construct($role = null, $spAcct = null, $serviceProviderName = null, $userPrefs = null)
    {
        $this
            ->setRole($role)
            ->setSpAcct($spAcct)
            ->setServiceProviderName($serviceProviderName)
            ->setUserPrefs($userPrefs);
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \EnumType\RoleTypeEnum::valueIsValid()
     * @uses \EnumType\RoleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \StructType\UserAccessInfoImpl
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleTypeEnum::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $role, implode(', ', \EnumType\RoleTypeEnum::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get spAcct value
     * @return string|null
     */
    public function getSpAcct()
    {
        return $this->spAcct;
    }
    /**
     * Set spAcct value
     * @param string $spAcct
     * @return \StructType\UserAccessInfoImpl
     */
    public function setSpAcct($spAcct = null)
    {
        // validation for constraint: string
        if (!is_null($spAcct) && !is_string($spAcct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spAcct)), __LINE__);
        }
        $this->spAcct = $spAcct;
        return $this;
    }
    /**
     * Get serviceProviderName value
     * @return string|null
     */
    public function getServiceProviderName()
    {
        return $this->serviceProviderName;
    }
    /**
     * Set serviceProviderName value
     * @param string $serviceProviderName
     * @return \StructType\UserAccessInfoImpl
     */
    public function setServiceProviderName($serviceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderName) && !is_string($serviceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderName)), __LINE__);
        }
        $this->serviceProviderName = $serviceProviderName;
        return $this;
    }
    /**
     * Get userPrefs value
     * @return string|null
     */
    public function getUserPrefs()
    {
        return $this->userPrefs;
    }
    /**
     * Set userPrefs value
     * @param string $userPrefs
     * @return \StructType\UserAccessInfoImpl
     */
    public function setUserPrefs($userPrefs = null)
    {
        // validation for constraint: string
        if (!is_null($userPrefs) && !is_string($userPrefs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userPrefs)), __LINE__);
        }
        $this->userPrefs = $userPrefs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserAccessInfoImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
