<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telephonyPlanBaseImpl StructType
 * @subpackage Structs
 */
class TelephonyPlanBaseImpl extends AbsTransientPlanImpl
{
    /**
     * The language
     * @var string
     */
    public $language;
    /**
     * Constructor method for telephonyPlanBaseImpl
     * @uses TelephonyPlanBaseImpl::setLanguage()
     * @param string $language
     */
    public function __construct($language = null)
    {
        $this
            ->setLanguage($language);
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @uses \EnumType\LanguageTypeEnum::valueIsValid()
     * @uses \EnumType\LanguageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $language
     * @return \StructType\TelephonyPlanBaseImpl
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LanguageTypeEnum::valueIsValid($language)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $language, implode(', ', \EnumType\LanguageTypeEnum::getValidValues())), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephonyPlanBaseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
