<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telephonyBulkBaseImpl StructType
 * @subpackage Structs
 */
class TelephonyBulkBaseImpl extends AbstractStructBase
{
    /**
     * The servicePlanId
     * @var string
     */
    public $servicePlanId;
    /**
     * The accountPoolingGroup
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var string
     */
    public $accountPoolingGroup;
    /**
     * Constructor method for telephonyBulkBaseImpl
     * @uses TelephonyBulkBaseImpl::setServicePlanId()
     * @uses TelephonyBulkBaseImpl::setAccountPoolingGroup()
     * @param string $servicePlanId
     * @param string $accountPoolingGroup
     */
    public function __construct($servicePlanId = null, $accountPoolingGroup = '0')
    {
        $this
            ->setServicePlanId($servicePlanId)
            ->setAccountPoolingGroup($accountPoolingGroup);
    }
    /**
     * Get servicePlanId value
     * @return string|null
     */
    public function getServicePlanId()
    {
        return $this->servicePlanId;
    }
    /**
     * Set servicePlanId value
     * @param string $servicePlanId
     * @return \StructType\TelephonyBulkBaseImpl
     */
    public function setServicePlanId($servicePlanId = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlanId) && !is_string($servicePlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlanId)), __LINE__);
        }
        $this->servicePlanId = $servicePlanId;
        return $this;
    }
    /**
     * Get accountPoolingGroup value
     * @return string|null
     */
    public function getAccountPoolingGroup()
    {
        return $this->accountPoolingGroup;
    }
    /**
     * Set accountPoolingGroup value
     * @param string $accountPoolingGroup
     * @return \StructType\TelephonyBulkBaseImpl
     */
    public function setAccountPoolingGroup($accountPoolingGroup = '0')
    {
        // validation for constraint: string
        if (!is_null($accountPoolingGroup) && !is_string($accountPoolingGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountPoolingGroup)), __LINE__);
        }
        $this->accountPoolingGroup = $accountPoolingGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephonyBulkBaseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
