<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subscriptions StructType
 * @subpackage Structs
 */
class Subscriptions extends AbstractStructBase
{
    /**
     * The subscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BurstSubscriptionImpl[]
     */
    public $subscription;
    /**
     * Constructor method for subscriptions
     * @uses Subscriptions::setSubscription()
     * @param \StructType\BurstSubscriptionImpl[] $subscription
     */
    public function __construct(array $subscription = array())
    {
        $this
            ->setSubscription($subscription);
    }
    /**
     * Get subscription value
     * @return \StructType\BurstSubscriptionImpl[]|null
     */
    public function getSubscription()
    {
        return $this->subscription;
    }
    /**
     * Set subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\BurstSubscriptionImpl[] $subscription
     * @return \StructType\Subscriptions
     */
    public function setSubscription(array $subscription = array())
    {
        foreach ($subscription as $subscriptionsSubscriptionItem) {
            // validation for constraint: itemType
            if (!$subscriptionsSubscriptionItem instanceof \StructType\BurstSubscriptionImpl) {
                throw new \InvalidArgumentException(sprintf('The subscription property can only contain items of \StructType\BurstSubscriptionImpl, "%s" given', is_object($subscriptionsSubscriptionItem) ? get_class($subscriptionsSubscriptionItem) : gettype($subscriptionsSubscriptionItem)), __LINE__);
            }
        }
        $this->subscription = $subscription;
        return $this;
    }
    /**
     * Add item to subscription value
     * @throws \InvalidArgumentException
     * @param \StructType\BurstSubscriptionImpl $item
     * @return \StructType\Subscriptions
     */
    public function addToSubscription(\StructType\BurstSubscriptionImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BurstSubscriptionImpl) {
            throw new \InvalidArgumentException(sprintf('The subscription property can only contain items of \StructType\BurstSubscriptionImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subscription[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subscriptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
