<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for serviceProviderImpl StructType
 * @subpackage Structs
 */
class ServiceProviderImpl extends AbstractStructBase
{
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The accountName
     * @var string
     */
    public $accountName;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The accountMgrId
     * @var string
     */
    public $accountMgrId;
    /**
     * The plmnId
     * @var string
     */
    public $plmnId;
    /**
     * The extractionFormat
     * @var string
     */
    public $extractionFormat;
    /**
     * The trackingEnabled
     * @var bool
     */
    public $trackingEnabled;
    /**
     * The reportingEnabled
     * @var bool
     */
    public $reportingEnabled;
    /**
     * The exemptEnabled
     * @var bool
     */
    public $exemptEnabled;
    /**
     * The lateFeePercent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lateFeePercent;
    /**
     * The paymentTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paymentTerms;
    /**
     * The gracePeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gracePeriod;
    /**
     * The messageText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $messageText;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The configList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ConfigList
     */
    public $configList;
    /**
     * Constructor method for serviceProviderImpl
     * @uses ServiceProviderImpl::setAccountNumber()
     * @uses ServiceProviderImpl::setAccountName()
     * @uses ServiceProviderImpl::setStatus()
     * @uses ServiceProviderImpl::setAccountMgrId()
     * @uses ServiceProviderImpl::setPlmnId()
     * @uses ServiceProviderImpl::setExtractionFormat()
     * @uses ServiceProviderImpl::setTrackingEnabled()
     * @uses ServiceProviderImpl::setReportingEnabled()
     * @uses ServiceProviderImpl::setExemptEnabled()
     * @uses ServiceProviderImpl::setLateFeePercent()
     * @uses ServiceProviderImpl::setPaymentTerms()
     * @uses ServiceProviderImpl::setGracePeriod()
     * @uses ServiceProviderImpl::setMessageText()
     * @uses ServiceProviderImpl::setStartDate()
     * @uses ServiceProviderImpl::setEndDate()
     * @uses ServiceProviderImpl::setConfigList()
     * @param string $accountNumber
     * @param string $accountName
     * @param string $status
     * @param string $accountMgrId
     * @param string $plmnId
     * @param string $extractionFormat
     * @param bool $trackingEnabled
     * @param bool $reportingEnabled
     * @param bool $exemptEnabled
     * @param string $lateFeePercent
     * @param string $paymentTerms
     * @param string $gracePeriod
     * @param string $messageText
     * @param string $startDate
     * @param string $endDate
     * @param \StructType\ConfigList $configList
     */
    public function __construct($accountNumber = null, $accountName = null, $status = null, $accountMgrId = null, $plmnId = null, $extractionFormat = null, $trackingEnabled = null, $reportingEnabled = null, $exemptEnabled = null, $lateFeePercent = null, $paymentTerms = null, $gracePeriod = null, $messageText = null, $startDate = null, $endDate = null, \StructType\ConfigList $configList = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setAccountName($accountName)
            ->setStatus($status)
            ->setAccountMgrId($accountMgrId)
            ->setPlmnId($plmnId)
            ->setExtractionFormat($extractionFormat)
            ->setTrackingEnabled($trackingEnabled)
            ->setReportingEnabled($reportingEnabled)
            ->setExemptEnabled($exemptEnabled)
            ->setLateFeePercent($lateFeePercent)
            ->setPaymentTerms($paymentTerms)
            ->setGracePeriod($gracePeriod)
            ->setMessageText($messageText)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setConfigList($configList);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\ServiceProviderImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get accountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->accountName;
    }
    /**
     * Set accountName value
     * @param string $accountName
     * @return \StructType\ServiceProviderImpl
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->accountName = $accountName;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ServiceProviderImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get accountMgrId value
     * @return string|null
     */
    public function getAccountMgrId()
    {
        return $this->accountMgrId;
    }
    /**
     * Set accountMgrId value
     * @param string $accountMgrId
     * @return \StructType\ServiceProviderImpl
     */
    public function setAccountMgrId($accountMgrId = null)
    {
        // validation for constraint: string
        if (!is_null($accountMgrId) && !is_string($accountMgrId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountMgrId)), __LINE__);
        }
        $this->accountMgrId = $accountMgrId;
        return $this;
    }
    /**
     * Get plmnId value
     * @return string|null
     */
    public function getPlmnId()
    {
        return $this->plmnId;
    }
    /**
     * Set plmnId value
     * @param string $plmnId
     * @return \StructType\ServiceProviderImpl
     */
    public function setPlmnId($plmnId = null)
    {
        // validation for constraint: string
        if (!is_null($plmnId) && !is_string($plmnId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plmnId)), __LINE__);
        }
        $this->plmnId = $plmnId;
        return $this;
    }
    /**
     * Get extractionFormat value
     * @return string|null
     */
    public function getExtractionFormat()
    {
        return $this->extractionFormat;
    }
    /**
     * Set extractionFormat value
     * @uses \EnumType\ExtractionFormatEnum::valueIsValid()
     * @uses \EnumType\ExtractionFormatEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $extractionFormat
     * @return \StructType\ServiceProviderImpl
     */
    public function setExtractionFormat($extractionFormat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExtractionFormatEnum::valueIsValid($extractionFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $extractionFormat, implode(', ', \EnumType\ExtractionFormatEnum::getValidValues())), __LINE__);
        }
        $this->extractionFormat = $extractionFormat;
        return $this;
    }
    /**
     * Get trackingEnabled value
     * @return bool|null
     */
    public function getTrackingEnabled()
    {
        return $this->trackingEnabled;
    }
    /**
     * Set trackingEnabled value
     * @param bool $trackingEnabled
     * @return \StructType\ServiceProviderImpl
     */
    public function setTrackingEnabled($trackingEnabled = null)
    {
        $this->trackingEnabled = $trackingEnabled;
        return $this;
    }
    /**
     * Get reportingEnabled value
     * @return bool|null
     */
    public function getReportingEnabled()
    {
        return $this->reportingEnabled;
    }
    /**
     * Set reportingEnabled value
     * @param bool $reportingEnabled
     * @return \StructType\ServiceProviderImpl
     */
    public function setReportingEnabled($reportingEnabled = null)
    {
        $this->reportingEnabled = $reportingEnabled;
        return $this;
    }
    /**
     * Get exemptEnabled value
     * @return bool|null
     */
    public function getExemptEnabled()
    {
        return $this->exemptEnabled;
    }
    /**
     * Set exemptEnabled value
     * @param bool $exemptEnabled
     * @return \StructType\ServiceProviderImpl
     */
    public function setExemptEnabled($exemptEnabled = null)
    {
        $this->exemptEnabled = $exemptEnabled;
        return $this;
    }
    /**
     * Get lateFeePercent value
     * @return string|null
     */
    public function getLateFeePercent()
    {
        return $this->lateFeePercent;
    }
    /**
     * Set lateFeePercent value
     * @param string $lateFeePercent
     * @return \StructType\ServiceProviderImpl
     */
    public function setLateFeePercent($lateFeePercent = null)
    {
        // validation for constraint: string
        if (!is_null($lateFeePercent) && !is_string($lateFeePercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lateFeePercent)), __LINE__);
        }
        $this->lateFeePercent = $lateFeePercent;
        return $this;
    }
    /**
     * Get paymentTerms value
     * @return string|null
     */
    public function getPaymentTerms()
    {
        return $this->paymentTerms;
    }
    /**
     * Set paymentTerms value
     * @param string $paymentTerms
     * @return \StructType\ServiceProviderImpl
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTerms) && !is_string($paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTerms)), __LINE__);
        }
        $this->paymentTerms = $paymentTerms;
        return $this;
    }
    /**
     * Get gracePeriod value
     * @return string|null
     */
    public function getGracePeriod()
    {
        return $this->gracePeriod;
    }
    /**
     * Set gracePeriod value
     * @param string $gracePeriod
     * @return \StructType\ServiceProviderImpl
     */
    public function setGracePeriod($gracePeriod = null)
    {
        // validation for constraint: string
        if (!is_null($gracePeriod) && !is_string($gracePeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gracePeriod)), __LINE__);
        }
        $this->gracePeriod = $gracePeriod;
        return $this;
    }
    /**
     * Get messageText value
     * @return string|null
     */
    public function getMessageText()
    {
        return $this->messageText;
    }
    /**
     * Set messageText value
     * @param string $messageText
     * @return \StructType\ServiceProviderImpl
     */
    public function setMessageText($messageText = null)
    {
        // validation for constraint: string
        if (!is_null($messageText) && !is_string($messageText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messageText)), __LINE__);
        }
        $this->messageText = $messageText;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ServiceProviderImpl
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ServiceProviderImpl
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get configList value
     * @return \StructType\ConfigList|null
     */
    public function getConfigList()
    {
        return $this->configList;
    }
    /**
     * Set configList value
     * @param \StructType\ConfigList $configList
     * @return \StructType\ServiceProviderImpl
     */
    public function setConfigList(\StructType\ConfigList $configList = null)
    {
        $this->configList = $configList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceProviderImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
